/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.0                               *
 * *************************************/

#include <stdio.h>
#include <malloc.h>
#include <memory.h>
#include <stdlib.h>
#include <math.h>
#include <string.h> // pour avoir memmove (microsoft bug)
#include "image.h"

void corr(image *im, char *filename, char c)
{
	char ff[]="corrx.bmp\0";

	image *imREF=new image(filename);
	imREF->pad(im->Height, im->Width, 128);
	ff[4]=c; imREF->save(ff);
	imageD *imdREF=new imageD(imREF);
	delete imREF;
	imdREF->calc_FFT();
	imageD *imd=new imageD(im);
	imd->calc_FFT();

	imdREF->correlation(imd);
	delete imd;
	WORD x,y;
	imdREF->find_max(&x,&y);
	double a=imdREF->gl[y][x]/(double)(imdREF->Size);
	image *im2=new image(imdREF,1);
	delete imdREF;
	ff[4]++; im2->save(ff);
	delete im2;
	printf("correlation between input image and reference image '%s'=%f\n",filename,a);		
}

int main(int argc, char *argv[])
{
	image *im1=new image("input2.bmp");
	double filterratio=0.5;
	BYTE filterlevel=20;
	double floodfillcut=0.1;
	double scaleX=0.5;
	double scaleY=0.5;
	im1->process( filterratio,
 				  filterlevel,
 				  floodfillcut,
				  scaleX,
				  scaleY);
	im1->save("inter2.bmp");
	double featureCutlevel=0.85;
	im1->analyse();
	image *im2=new image(im1,featureCutlevel);
	delete im1;
	im2->save("inter3.bmp");
	im2->pad(128);
	im2->save("inter4.bmp");

	corr(im2,"duck.bmp", '0');
	corr(im2,"tomato.bmp", '2');

	delete im2;
	im1=new image("input.bmp");
	im1->pad(128);
	im1->save("inter5.bmp");
	corr(im1,"duck.bmp", '4');
	delete im1;
	return 0;
};
