/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.0                               *
 * *************************************/

#ifndef image_library_1
#define image_library_1 1

#include <stdio.h>
#include "definitions.h"

int LogOf2(int a);
int IsPowerOf2(WORD a);

class imageD;

class image
{
public:
	// initialised by init_fast_access() :
	BYTE    **fgl;
	// allways initialised :
	BYTE    *gl;
	WORD    Width,Height;
	DWORD   Size;
	// initialised by analyse():
	WORD    gravityH,gravityW;
	long    total;
	double  minGL,maxGL;
	double  pixBsurN;
	// initialised by Ceil()&analyse():
	DWORD   Surface;

	image(): fgl(NULL){}; 
	image(char *name);
	image(image *im,double scaleX,double scaleY);
	void initFrom(image *im);
	image(image *im, double ratio);
	image(WORD _Width,WORD _Height,BYTE c);
	image(imageD *im,BYTE s);
	~image();
	void save(char *name);
	void find_max(WORD *x,WORD *y);	
	void find_min(WORD *x,WORD *y);
//	void init_fast_access();
	void imCeil(double ratio,BYTE threshold);
	void analyse();
	void analyse_simple();
	void filter(image *filtre, BYTE color, BYTE threshold);
	BYTE *flood_fill(WORD x, WORD y,BYTE cons);
	void crop(BYTE c);
	BYTE centerCrop(int _w,int _h);
                      // retourne 1 si l'image a pris exactement les dimensions w et h.
	BYTE pad(WORD w,WORD h,BYTE c); // retourne 1 si l'image a pris exactement les dimensions
									// w et h. L'image finale est au moins aussi grande que
									// [w,h] (peut-tre plus). La zone de l'image qui est 
									// ajoute est de couleur C.
	void pad(BYTE c); // pad with color c so that height and width be a power of 2
	DWORD countWpeak(int treshold);
	DWORD countHpeak(int treshold);	
	DWORD countRpeak(int treshold, WORD x, WORD y);
	DWORD countApeak(int treshold, int portions, WORD x, WORD y);
	void process(double ratio,BYTE threshold,double anti_treshold_ratio,
		double scaleX,double scaleY);
};

class imageD
{
public:
	double   **gl,**fft,*speq;
	WORD    Width,Height;
	DWORD   Size;
	
	imageD(imageD *im,double scaleX,double scaleY);
	imageD(WORD _Width,WORD _Height,double c);
	imageD(image *im);
	imageD(imageD *im,WORD w,WORD h);
	~imageD();	
	void correlation(imageD *im);
	void calc_FFT();
	void find_max(WORD *x,WORD *y);	
	void save(char *filename,int i=1);
//	double maxCorrelation(imageD *im);
//	void normaliseFFT();
//	void cutHighFreq(int n);
};

#endif