/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 ***************************************/

#ifndef __INCLUDE_RRBAGFSC45__
#define __INCLUDE_RRBAGFSC45__

#include <stdio.h>
#include "definitions.h"
#include "classifier.h"
#include "BAGFSC45.h"
#include "DataSet.h"

#ifdef __NO_DATASET__
#define __EVAL_ONLY__
#endif

class BoostedC45 : public Classifier
{
  public:
    BoostedC45 (FILE *stream);
	~BoostedC45 ();
	ClassNo eval(double *features,double *confidence);
	int B;
  protected:
    C45 **TreeTable;
    int nClasses, MinClass;
    double *vote;

#ifndef __EVAL_ONLY__
  public:
	BoostedC45(DataSet *D, int _B=0);
    void save(FILE *f);
#endif
};


class RRBAGFSC45 : public Classifier
{
  public:
    RRBAGFSC45(FILE *stream);
	~RRBAGFSC45();
	ClassNo eval(double *features,double *confidence);
  protected:
    double *vote;
    Classifier **rr;
    int nClassifier,MinClass,MaxClass;

#ifndef __EVAL_ONLY__
  public:
	RRBAGFSC45(DataSet *D, int K=-1, int B=10);
        // if K==0 then calculation of optimal K is performed
        // if B==0 then calculation of optimal B is performed
      // if ((K==-1)&&(B==1)), we have BAGFSC45 := simple C45
    void save(FILE *f);

#endif
};


class StackedRRBAGFSC45 : public RRBAGFSC45
{
  public:
    StackedRRBAGFSC45(FILE *stream);
	~StackedRRBAGFSC45();
	ClassNo eval(double *features,double *confidence);
  protected:
    BinaryDataSet *bds;
    unsigned char *binaryVector; 
    int *distClass, *occurence;
  private:
    void initMemory();
    void constructBinaryResponse(double *feature, unsigned char *d);

#ifndef __EVAL_ONLY__
  public:
	StackedRRBAGFSC45(DataSet *D, int K=-1, int B=10);
    StackedRRBAGFSC45(DataSet *D, FILE *f);
        // if K==0 then calculation of optimal K is performed
        // if B==0 then calculation of optimal B is performed
      // if ((K==-1)&&(B==1)), we have BAGFSC45 := simple C45
    void save(FILE *f);
  private:
    void finishInit(DataSet *D);

#endif

};


#endif

