/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 ***************************************/

#ifndef __INCLUDE__classifier_h__
#define __INCLUDE__classifier_h__

#ifdef __NO_DATASET__
#define __EVAL_ONLY__
#else
    #include "DataSet.h"
#endif
#ifdef __INSIDE_GVB_SERVER__
   #include <pthread.h>
#endif

#include "definitions.h"

class Classifier
{
  public:
    char *name;
    Classifier();
    virtual ~Classifier();
	virtual ClassNo eval(double *features,double *confidence)=0;
#ifndef __NO_DATASET__
	int Different(Classifier *b, DataSet *ItemTest);
    void createAndSaveConfMatrix(DataSet *D, char *filename);
	void UpdateConfusionMatrix(int *,DataSet *D, char verbose=0);
	static double kappa(int *conf, DataSet *D);
	double Classifier::kappa(DataSet *D);
	static void SaveConfusionMatrix(char *filename, int *conf, DataSet *D);
#endif
#ifndef __EVAL_ONLY__
    virtual void save(char *name=NULL);
    virtual void save(FILE *f)=0;
#endif

#ifdef __INSIDE_GVB_SERVER__
    int nUtilisateur;
    Boolean fin;
    pthread_mutex_t Cmutex;
};
void Classifier_lock(Classifier *C);
void Classifier_unlock(Classifier *C);
void Classifier_delete(Classifier *C);
#else
};
#endif

Classifier *NewClassifier(char *filename);
Classifier *NewClassifier(FILE *f, char *filename=NULL);

#endif

