/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 ***************************************/

#include <stdlib.h>
#include <memory.h>
#include "BAGFSC45.h"
#include "DataSet.h"

#define CrossValParts 10

int main(int argc, char **argv)
{
	BAGFSC45 *current;
	DataSet *AllDatas, *SetCreate, *SetTest;
	int i,K,MaxClass,*confusionMat;
	if ((argc!=2)&&(argc!=3))
	{
		printf("SYNTAX: kc_coherence <DataSet_file> [<K>]\n\n"
			   "The goal of this program is to test the coherence of the data set\n"
			   "in <data_file>. If <K> is nul or not specified then calculation\n"
			   "to find optimal K is performed. A file called 'confusion_matrixC.txt'\n"
			   "will be generated.\n");
		exit(255);
	};
    AllDatas=new DataSet(argv[1]); 
    MaxClass=AllDatas->MaxClass;

    if (argc==3) K=atol(argv[2]); else K=BAGFSC45::FindOptimalK(AllDatas);
	printf("optimal K=%i / %i\n",K,AllDatas->MaxAtt);
	confusionMat=(int*)malloc(MaxClass*MaxClass*sizeof(int));
	memset(confusionMat,0,MaxClass*MaxClass*sizeof(int));

	for (i=0; i<CrossValParts; i++)
	{
		printf("general crossval part %i/%i\n",i+1,CrossValParts);
		SetCreate=AllDatas->generate_Create_Set(i, CrossValParts);
		SetTest=AllDatas->generate_Test_Set(i, CrossValParts);

		printf("building BAGFSC45.\n");
		current= new BAGFSC45(SetCreate,K);

		printf("updating confusion matrix\n");
		current->UpdateConfusionMatrix(confusionMat,SetTest);

		delete(current); delete(SetCreate); delete(SetTest);
	};

	printf("Saving confusion matrix 'confusion_matrixC.txt'\n");
	Classifier::SaveConfusionMatrix("confusion_matrixC.txt",confusionMat,AllDatas);

	free(confusionMat);
	delete(AllDatas);
	//getchar();
	return 0;
};
