/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 ***************************************/

#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include <string.h>
#include "DataSet.h"

int main(int argc, char **argv)
{
    char buf[3000], *b2;
	DataSet *D, *ds1;
    double n;
    FILE *f;

    if (argc>2) n=atof(argv[2]);

	if ((argc<3)||(n<=0.0)||((n>1.0)&&(n!=double((int)n))))
	{
		printf("SYNTAX: kc_cutDS <DataSet_file> <number> [<base_name_for_ouput_DataSet_file>]\n\n"
			   "The goal of this program is to cut a <DataSet_file> into at least 2 Datasets.\n"
               "Some work is performed to ensure that the class distribution is the same among\n"
               "all the generated datasets.\n\n"
               "if <number> < 1.0, then The dataset is cut in two parts: the first part contains\n"
               "                        <number> %% of the examples. The second part contains the\n"
               "                        remaining examples. (<number> is a floating number)\n"
               "if <number> > 1    then The dataset is cutted into <number> equal parts.\n"
               "                        (<number> is an integer in this case).\n");
		exit(255);
	};

	D=new DataSet(argv[1]);
    printf("\nRead %d cases (%d attributes)\n",D->nItem, D->MaxAtt);

    if (argc==4) { strcpy(buf,argv[3]); b2=buf+strlen(buf); }
    else 
    { 
        char *b=buf;
        strcpy(buf, argv[1]);
        while (*b!='\0') { if (*b=='.') b2=b; b++; }
    }

    if (n<1.0)
    {
        ds1 = D->generate_Create_Set(0, 1.0/n);
        strcpy(b2,"_test.txt");
        f=fopen(buf,"w"); ds1->save(f); fclose(f);
        delete ds1;
        printf("."); fflush(stdout);
        ds1= D->generate_Test_Set(0, 1.0/n);
        strcpy(b2,"_create.txt");
        f=fopen(buf,"w"); ds1->save(f); fclose(f);
        delete ds1;
        printf(".");
    } else
    {
        int npart=(int)n,i;
        for (i=0; i<npart; i++)
        {
    		ds1=D->generate_Test_Set(i, npart);
            sprintf(b2,"_%02i.txt",i+1);
            f=fopen(buf,"w"); ds1->save(f); fclose(f);
            delete ds1;
            printf(".");
        }
    }
    printf("\nDataset(s) cutted successful.\n");
	// printf("press a key.\n"); getchar();
	return 0;
};
