/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 ***************************************/

#include <stdio.h>
#include <stdlib.h>
#include <memory.h> 
#include <string.h>
#include "RRBAGFSC45.h"
#include "DataSet.h"
#include "tools.h"
//#include <crtdbg.h>

int main(int argc, char **argv)
{
    char tline[3000];
	Classifier *c;
	DataSet *AllItem;

	if (argc<2)
	{
		printf("SYNTAX: kc_StackedRRgenerate <DataSet_file> [<output_RRBAGFSC45_file> [<RR_Classifier>]]\n\n"
			   "The goal of this program is to create a new classifier which is a stacked\n"
               "round robin classifier. <RR_Classifier> is the Round Robin classifier which\n"
               "will be used to create the new, derivated stacked round robin classifier. If\n"
               "<RR_Classifier> is not specified, a new classifier RR classifier will be \n"
               "created (with K=-1 and B=1). If <output_RRBAGFSC45_file> is not specified then\n"
               "the resulting classifier name will be based on the current date and time.\n");
		exit(255);
	};    
	
    AllItem=new DataSet(argv[1]);
    printf("\nRead %d cases (%d attributes)\n",AllItem->nItem, AllItem->MaxAtt);

    if (argc<4) c=new StackedRRBAGFSC45(AllItem);
    else
    {
        FILE *stream=fopen(argv[3],"r");
        fgets((char*)tline,300,stream);
        if (strncmp(tline,"Round Robin BAGFS Trees v1.00",29)!=0)
        {
            printf("Not a RR classifier.\n");
            exit(199);
        }
        c=new StackedRRBAGFSC45(AllItem, stream);
        fclose(stream);
    }

    if (argc>2) c->save(argv[2]);
	else c->save(); // ,AllItem->MinClass);
	
	printf("Stacked Round Robin Trees generation terminated successfully.\n");

   // c->createAndSaveConfMatrix(AllItem,"confusion_matrixV.txt");

	delete(c); delete(AllItem);


    // getchar();
	return 0;
};
