import java.awt.*;
import java.applet.*;

public class CCApplet extends Applet
{
        int w_height, w_width,info_height;
	double teta=10*Math.PI/180,sigmaX=-4,sigmaY=7,tauXY=5;

	//{{DECLARE_CONTROLS
	Label label1;
	java.awt.Label label2;
	java.awt.Label label3;
	java.awt.Label label4;
	java.awt.Label label5;
	java.awt.Label label6;
	java.awt.Label label7;
	java.awt.Label label8;
	java.awt.Label label9;
	java.awt.Label label10;
	java.awt.Label label11;
        java.awt.TextField t_sigmaX;
        java.awt.TextField t_sigmaY;
        java.awt.TextField t_tauXY;
        java.awt.TextField t_sigma1;
        java.awt.TextField t_sigma2;
        java.awt.TextField t_sigmaU;
        java.awt.TextField t_sigmaV;
        java.awt.TextField t_tauUV;
	java.awt.TextField t_teta;
	java.awt.TextField t_phy;
        java.awt.Button button1;
 	//}}

    
	public void init()
	{
	
		//{{INIT_CONTROLS
		setLayout(null);
      
                //get the size of the applet's drawing area
	        w_height = size().height; 
	        w_width = size().width; 
		if (w_height<300) setSize(w_width,300);
		if (w_width<590)  setSize(590,w_height);

             Font a_font;
             FontMetrics a_font_metric;
	     Graphics g=getGraphics();
	     setBackground(Color.getColor("",0xffffff));
		// previous line is usefull in Netscape 
             int font_height;

        	     //Make a new font
             a_font = new Font("Dialog",Font.PLAIN,12);

             g.setFont(a_font);
	             //get the metrics for the font
             a_font_metric = g.getFontMetrics();
         	    //get the height of the font
             font_height = a_font_metric.getAscent()+
			   a_font_metric.getDescent()+15;

		info_height=font_height*4+2;
                w_height-=info_height;
		
		label1 = new java.awt.Label("sigmaX=");
		label1.setBounds(10,w_height,60,font_height);
		add(label1);
                t_sigmaX = new TextField();
                t_sigmaX.setBounds(72,w_height,w_width/3-80,font_height);
		t_sigmaX.setFont(a_font);
                add(t_sigmaX);
  
		label2 = new java.awt.Label("sigmaY=");
		label2.setBounds(10,w_height+font_height,60,font_height);
		add(label2);
                t_sigmaY = new TextField();
                t_sigmaY.setBounds(72,w_height+font_height,w_width/3-80,font_height);
		t_sigmaY.setFont(a_font);
                add(t_sigmaY);

		label3 = new java.awt.Label("tauXY=");
		label3.setBounds(10,w_height+2*font_height,60,font_height);
		add(label3);
                t_tauXY = new TextField();
                t_tauXY.setBounds(72,w_height+2*font_height,w_width/3-80,font_height);
		t_tauXY.setFont(a_font);
                add(t_tauXY);

                button1 = new Button();
                button1.setLabel("  SET  ");
                button1.setBounds(10,w_height+3*font_height,w_width/3-20,font_height);
                button1.setBackground(new Color(12632256));
                add(button1);

		label4 = new java.awt.Label("sigma1=");
		label4.setBounds(10+w_width/3,w_height,60,font_height);
		add(label4);
                t_sigma1 = new TextField();
                t_sigma1.setEditable(false);
		t_sigma1.setBackground(Color.getColor("",0xB8B8B8));
			// previous line is usefull in Internet Explorer
                t_sigma1.setBounds(72+w_width/3,w_height,w_width/3-80,font_height);
		t_sigma1.setFont(a_font);
                add(t_sigma1);

		label5 = new java.awt.Label("sigma2=");
		label5.setBounds(10+w_width/3,w_height+font_height,60,font_height);
		add(label5);
                t_sigma2 = new TextField();
                t_sigma2.setEditable(false);
		t_sigma2.setBackground(Color.getColor("",0xB8B8B8));
                t_sigma2.setBounds(72+w_width/3,w_height+font_height,w_width/3-80,font_height);
		t_sigma2.setFont(a_font);
                add(t_sigma2);

		label6 = new java.awt.Label("phy=");
		label6.setBounds(10+w_width/3,w_height+2*font_height,60,font_height);
		add(label6);
                t_phy = new TextField();
                t_phy.setEditable(false);
		t_phy.setBackground(Color.getColor("",0xB8B8B8));
                t_phy.setBounds(72+w_width/3,w_height+2*font_height,w_width/3-80,font_height);
		t_phy.setFont(a_font);
                add(t_phy);

		label11= new java.awt.Label("(note: sigmaX // X)");
		label11.setBounds(10+w_width/3,w_height+3*font_height,130,font_height);
		add(label11);
                
		label7 = new java.awt.Label("sigmaU=");
		label7.setBounds(10+w_width*2/3,w_height,60,font_height);
		add(label7);
                t_sigmaU = new TextField();
                t_sigmaU.setEditable(false);
		t_sigmaU.setBackground(Color.getColor("",0xB8B8B8));
                t_sigmaU.setBounds(72+w_width*2/3,w_height,w_width/3-80,font_height);
		t_sigmaU.setFont(a_font);
                add(t_sigmaU);

		label8 = new java.awt.Label("sigmaV=");
		label8.setBounds(10+w_width*2/3,w_height+font_height,60,font_height);
		add(label8);
                t_sigmaV = new TextField();
                t_sigmaV.setEditable(false);
		t_sigmaV.setBackground(Color.getColor("",0xB8B8B8));
                t_sigmaV.setBounds(72+w_width*2/3,w_height+font_height,w_width/3-80,font_height);
		t_sigmaV.setFont(a_font);
                add(t_sigmaV);

		label9 = new java.awt.Label("tauUV=");
		label9.setBounds(10+w_width*2/3,w_height+2*font_height,60,font_height);
		add(label9);
                t_tauUV = new TextField();
                t_tauUV.setEditable(false);
		t_tauUV.setBackground(Color.getColor("",0xB8B8B8));
                t_tauUV.setBounds(72+w_width*2/3,w_height+2*font_height,w_width/3-80,font_height);
		t_tauUV.setFont(a_font);
                add(t_tauUV);

		label10 = new java.awt.Label("teta=");
		label10.setBounds(10+w_width*2/3,w_height+3*font_height,60,font_height);
		add(label10);
                t_teta = new TextField();
                t_teta.setBounds(72+w_width*2/3,w_height+3*font_height,w_width/3-80,font_height);
		t_teta.setFont(a_font);
                add(t_teta);

		t_teta.setText("10");
		t_sigmaX.setText(Double.toString(sigmaX));
		t_sigmaY.setText(Double.toString(sigmaY));
		t_tauXY.setText(Double.toString(tauXY));
		
		//}}
 
               //{{REGISTER_LISTENERS
                SymAction lSymAction = new SymAction();
	        t_teta.addActionListener(lSymAction);
		t_sigmaX.addActionListener(lSymAction);
		t_sigmaY.addActionListener(lSymAction);
		t_tauXY.addActionListener(lSymAction);

                SymMouse aSymMouse = new SymMouse();
                button1.addMouseListener(aSymMouse);
                //}}

		w_height-=5; info_height+=5; w_width/=2;
	}

        class SymAction implements java.awt.event.ActionListener
        {
                public void actionPerformed(java.awt.event.ActionEvent event)
                {
                        Object object = event.getSource();
                        if (object == t_teta) t_teta_EnterHit(event);
			else button1_MouseClick();
                }
        }

        class SymMouse extends java.awt.event.MouseAdapter
        {
                public void mouseClicked(java.awt.event.MouseEvent event)
                {
                        Object object = event.getSource();
                        if (object == button1)
                                button1_MouseClick();
                }
        }

	double convert(String S, double default1)
	{
		double temp;
                try { temp = Double.valueOf(S).doubleValue(); }
                catch (NumberFormatException e)  { temp=default1; };
		return temp;
	};

        void button1_MouseClick()
        {
		sigmaX=convert(t_sigmaX.getText(),sigmaX);
		t_sigmaX.setText(Double.toString(sigmaX));
		sigmaY=convert(t_sigmaY.getText(),sigmaY);
		t_sigmaY.setText(Double.toString(sigmaY));
		tauXY=convert(t_tauXY.getText(),tauXY);
		t_tauXY.setText(Double.toString(tauXY));
		calculate();
 	};

        void t_teta_EnterHit(java.awt.event.ActionEvent event)
        {
		teta=convert(t_teta.getText(),teta);
		teta=teta % 360;
		if (teta<0) teta+=360;
		if (teta>180) teta-=360;
		t_teta.setText(Float.toString((float)teta));
		teta=teta*Math.PI/180;
		calculate();
        };

	void calculate()
	{
             update(getGraphics());
	};

	public boolean mouseDown(Event e, int x, int y)
	{
	     return mouseDrag(e,x,y);
	}

        public boolean mouseDrag(Event e, int x, int y)
        {
	     if ((y>0)&&(y<w_height)&&(x>w_width)&&(x<2*w_width))
	     {
		int dx=x-w_width*3/2;
		int dy=w_height/2-y;
		if (dx==0) 
		  if (dy>0) teta=90; else teta=-90;
		else
		{
 		  teta=Math.atan((double)dy/(double)dx)*180/Math.PI;
		  if (dy<0)
		  {
		     if (dx<0) teta-=180;
		  }
		  else if (dx<0) teta+=180;
		}
   	        t_teta.setText(Float.toString((float)teta));
	        teta*=Math.PI/180;
	        calculate();
	     }
             return true;
        }

	double sqr(double d)
	{
	     return d*d;
	}

	void drawUnit(double ratio,int x,Graphics g)
	{
	    double unit=Math.exp(Math.log(10)*
				 (Math.floor(-Math.log(ratio)/Math.log(10))+2)
				);
	    g.setColor(Color.getColor("",0x000000));
	    g.drawLine(x+5,w_height-8,x+5,w_height-4);
	    g.drawLine(x+5,w_height-6,
		       (int)(x+5+unit*ratio),w_height-6);
	    g.drawLine((int)(x+5+unit*ratio),w_height-8,
		       (int)(x+5+unit*ratio),w_height-4);
	    g.drawString(Float.toString((float)unit),
			 x+6,w_height-10);
	};

        public void paint(Graphics g)
        {
	     int oy=w_height/2;

// LIGNES DE SEPARATION
             g.fillRect(0,w_height-1,w_width*2,3); 
             g.fillRect(w_width-1,0,3,w_height); 
	// axe sigmaX
             g.drawLine(10,oy,w_width-10,oy); 
	     g.drawLine(w_width-10,oy,w_width-15,oy-5); 
	     g.drawLine(w_width-10,oy,w_width-15,oy+5); 
	// axe X
             g.drawLine(w_width+10,oy,w_width*2-10,oy);
             g.drawLine(w_width*2-10,oy,w_width*2-15,oy-5);
             g.drawLine(w_width*2-10,oy,w_width*2-15,oy+5);
	     g.drawString("X" , w_width*2-10,oy-5);
	// axe Y
	     g.drawLine(w_width*3/2,10,w_width*3/2,w_height-10);
	     g.drawLine(w_width*3/2,10,w_width*3/2+5,15);
	     g.drawLine(w_width*3/2,10,w_width*3/2-5,15);
	     g.drawString("Y" , w_width*3/2-10,10);

	     g.drawLine(w_width*2/3,w_height,w_width*2/3,w_height+info_height);
	     g.drawLine(w_width*4/3,w_height,w_width*4/3,w_height+info_height);

// CAS LIMITE
	     if ((sigmaX==0)&&(sigmaY==0)&&(tauXY==0))
	     {
	// axe tauXY
	 	g.drawLine(w_width/2,10,w_width/2,w_height-10);
		g.drawLine(w_width/2,10,w_width/2+5,15);
		g.drawLine(w_width/2,10,w_width/2-5,15);
	// R(sigmaX,-tauXY)
	        g.setColor(Color.getColor("",0x0000FF));
  	        g.fillRect(w_width/2-2,w_height/2-2,4,4);
	// sigma1, sigma2, phy, sigmaU, sigmaV, tauUV
                t_sigma1.setText("0");
                t_sigma2.setText("0");
  		t_phy.setText("---");
                t_sigmaU.setText("0");
                t_sigmaV.setText("0");
                t_tauUV.setText("0");
	// vecteur n
	        g.setColor(Color.getColor("",0x0000FF));
	        g.drawLine(w_width*3/2,w_height/2, 
			(int)(w_width*3/2+50*Math.cos(teta)),
			(int)(w_height/2-50*Math.sin(teta)));
  	        g.drawString("N",
		   	     (int)(w_width*3/2-5+50*1.13*Math.cos(teta)),
			     (int)(w_height/2+5-50*1.13*Math.sin(teta)));
 		return;
	     }
// PLAN DU CERCLE DE MOHR

	     double inter1=(sigmaX-sigmaY)/2;
	     double rayon=Math.sqrt(sqr(inter1)+sqr(tauXY));
	     double centre=(sigmaX+sigmaY)/2;
	     double sigma1=centre+rayon;
	     double sigma2=centre-rayon;
	     double diametre=rayon*2; // diametre=sigma1-sigma2>0
	     double phy=0;
	     if (rayon!=0) phy=Math.atan(tauXY/inter1)/2;
	     if (tauXY*phy<0) if (phy<0) phy+=Math.PI/2; else phy-=Math.PI/2;

             double taille;
             if (w_width>w_height) taille=w_height-30; else taille=w_width-30;

	     double ratio;
	     int ox;
	     if (sigma1*sigma2>0)
	     {
		double inter5;
	        if (sigma1>0) { ox=15; inter5=sigma1; }
		else { ox=w_width-15; inter5=-sigma2; }
	        double inter6=((double)(w_width-30))/inter5;
                double inter7=((double)(w_height-30))/diametre;
		if (inter6>inter7) ratio=inter7; else ratio=inter6;
	     }
	     else
	     {
		ox=(int)((w_width-taille)/2+taille*-sigma2/diametre);
		ratio=taille/diametre;
	     };

	// unite
	     drawUnit(ratio,0,g);

	// axe tauXY
	     g.drawLine(ox,10,ox,w_height-10);
	     g.drawLine(ox,w_height-10,ox-5,w_height-15);
	     g.drawLine(ox,w_height-10,ox+5,w_height-15);

	   double sigmaU=centre+inter1*Math.cos(2*teta)+tauXY*Math.sin(2*teta);
	   double sigmaV=centre-inter1*Math.cos(2*teta)-tauXY*Math.sin(2*teta);
	   double tauUV=-inter1*Math.sin(2*teta)+tauXY*Math.cos(2*teta);

	     t_sigma1.setText(Float.toString((float)sigma1));
	     t_sigma2.setText(Float.toString((float)sigma2));
	     if (rayon==0)
	     {
		t_phy.setText("---");
		g.fillRect((int)(ox-2+centre*ratio),oy-2,4,4);
		g.drawString("R",(int)(ox-5+centre*ratio),oy-10);
	     }
	     else
	     {
		t_phy.setText(Float.toString((float)(phy*180/Math.PI)));

	// cercle de Mohr
	     g.drawArc((int)(ox+sigma2*ratio),(int)(oy-rayon*ratio),
		       (int)(diametre*ratio),(int)(diametre*ratio),0,360);
	     g.fillRect((int)(ox+sigma1*ratio-2),oy-2,4,4);
	     g.fillRect((int)(ox+sigma2*ratio-2),oy-2,4,4);
	     g.drawString("I" , (int)(ox+3+sigma1*ratio),oy-2);
	     g.drawString("II", (int)(ox-12+sigma2*ratio),oy-2);

	// R(sigmaX,-tauXY)
//	     g.setColor(Color.getColor("",0x000000));
	     g.fillRect((int)(ox+sigmaX*ratio-2),
			(int)(oy-tauXY*ratio-2),4,4);
	     g.drawString("R",
			  (int)(ox-5+centre*ratio+(sigmaX-centre)*1.13*ratio),
			  (int)(oy+5-tauXY*1.1*ratio));
	

	// Diametre - plan de Mohr
	     g.setColor(Color.getColor("",0x008000));
	     g.drawLine((int)(ox+sigmaU*ratio),
                        (int)(oy+tauUV*ratio),
			(int)(ox+(2*centre-sigmaU)*ratio),
			(int)(oy-tauUV*ratio));

	// Lignes de Construction - plan de Mohr
	     g.setColor(Color.getColor("",0xE000E0)); //pink
	     g.drawLine(ox-1,(int)(oy+tauUV*ratio),
			ox+1,(int)(oy+tauUV*ratio));
	     g.drawLine((int)(ox+sigmaU*ratio),oy,
			(int)(ox+sigmaU*ratio),
			(int)(oy+tauUV*ratio));
	     g.drawLine((int)(ox+(2*centre-sigmaU)*ratio),oy,
			(int)(ox+(2*centre-sigmaU)*ratio),
			(int)(oy-tauUV*ratio));
	     g.fillRect((int)(ox+(2*centre-sigmaU)*ratio-2),
			(int)(oy-tauUV*ratio-2),4,4);
	     g.drawString("V",
			  (int)(ox-5+centre*ratio+(centre-sigmaU)*1.13*ratio),
			  (int)(oy+5-tauUV*1.1*ratio));
	     g.fillRect((int)(ox+sigmaU*ratio-2),
			(int)(oy+tauUV*ratio-2),4,4);
	     g.drawString("U",
			  (int)(ox-5+centre*ratio+(sigmaU-centre)*1.13*ratio),
			  (int)(oy+5+tauUV*1.1*ratio));

	     g.setColor(Color.getColor("",0xFF0000)); //red
	     g.drawLine((int)(ox+sigmaX*ratio),
                        (int)(oy-tauXY*ratio),
			(int)(ox+sigmaU*ratio),
			(int)(oy+tauUV*ratio));
	     g.setColor(Color.getColor("",0x0000FF)); //blue
	     g.drawLine((int)(ox+sigmaX*ratio),
                        (int)(oy-tauXY*ratio),
			(int)(ox+(2*centre-sigmaU)*ratio),
			(int)(oy-tauUV*ratio));
	     };
	    
// PLAN XY
	     ox=w_width*3/2;
	     taille/=2;
	     if (Math.abs(sigma1)>Math.abs(sigma2))
	     	ratio=taille/Math.abs(sigma1);
	     else
	     	ratio=taille/Math.abs(sigma2);

	// unite
	    drawUnit(ratio,w_width,g);

	    if (rayon!=0)
	    {
		// vecteur N1
		    g.setColor(Color.getColor("",0x008000));
		    g.drawLine(ox,oy,
			       (int)(ox+taille*Math.cos(phy)),
	 	       	       (int)(oy-taille*Math.sin(phy)));
		    g.drawString("N1",
			         (int)(ox-10+taille*1.13*Math.cos(phy)),
	 	       	         (int)(oy+5-taille*1.13*Math.sin(phy)));

		//vecteur N2
		    g.setColor(Color.getColor("",0xB0B010));
		    g.drawLine(ox,oy,
			       (int)(ox-taille*Math.sin(phy)),
	 		       (int)(oy-taille*Math.cos(phy)));
		    g.drawString("N2",
			         (int)(ox-10-taille*1.15*Math.sin(phy)),
	 		         (int)(oy+5-taille*1.15*Math.cos(phy)));
	    };

	// vecteur Tn	    3
	//		|-------|
	//		|     / |
	//	       4|   /1  |2
	//		| /     |
	//		|-------|
	//		    5

	// Tn(1)
	     g.setColor(Color.getColor("",0xE000E0));
	     g.drawLine(ox,oy,
			(int)(ox+ratio*
				(sigmaU*Math.cos(teta)-tauUV*Math.sin(teta))),
			(int)(oy-ratio*
				(sigmaU*Math.sin(teta)+tauUV*Math.cos(teta))));
	     g.drawString("Tn",
			  (int)(ox-10+1.2*ratio*
				(sigmaU*Math.cos(teta)-tauUV*Math.sin(teta))),
			  (int)(oy+5-1.15*ratio*
				(sigmaU*Math.sin(teta)+tauUV*Math.cos(teta))));
	// Tn(2)
	     g.drawLine((int)(ox+ratio*sigmaU*Math.cos(teta)),
			(int)(oy-ratio*sigmaU*Math.sin(teta)),
			(int)(ox+ratio*
				(sigmaU*Math.cos(teta)-tauUV*Math.sin(teta))),
			(int)(oy-ratio*
				(sigmaU*Math.sin(teta)+tauUV*Math.cos(teta))));
	// Tn(3)
	     g.drawLine((int)(ox-ratio*tauUV*Math.sin(teta)),
			(int)(oy-ratio*tauUV*Math.cos(teta)),
			(int)(ox+ratio*
				(sigmaU*Math.cos(teta)-tauUV*Math.sin(teta))),
			(int)(oy-ratio*
				(sigmaU*Math.sin(teta)+tauUV*Math.cos(teta))));
	// Tn(4)
	     g.setColor(Color.getColor("",0xFF0000));	
	     g.drawLine((int)(ox-ratio*tauUV*Math.sin(teta)),
			(int)(oy-ratio*tauUV*Math.cos(teta)),ox,oy);
	// Tn(5)
	     g.setColor(Color.getColor("",0x0000FF));	
	     g.drawLine((int)(ox+ratio*sigmaU*Math.cos(teta)),
			(int)(oy-ratio*sigmaU*Math.sin(teta)),ox,oy);
	     
	// vecteur n
	     g.drawLine(ox,oy, 
			(int)(ox+(taille+5)*Math.cos(teta)),
			(int)(oy-(taille+5)*Math.sin(teta)));
	     g.drawString("N",
			  (int)(ox-5+(taille+5)*1.13*Math.cos(teta)),
			  (int)(oy+5-(taille+5)*1.13*Math.sin(teta)));

	     t_sigmaU.setText(Float.toString((float)sigmaU));
	     t_sigmaV.setText(Float.toString((float)sigmaV));
	     t_tauUV.setText(Float.toString((float)tauUV));

// INFOS
             super.paint(g);
        }
}
