#include <windows.h>
#include <stdio.h>

DWORD hexVal(char *b, int n)
{
	int i;
	DWORD tmp=0;
	for (i=0; i<n; i++)
	{
		if (b[i]<'a') tmp=(tmp<<4)+(b[i]-'0');
		else tmp=(tmp<<4)+(b[i]-'a'+10);
	}
	return tmp;
}

int main(int argc, char **argv)
{
	char curDir[5000];
	char defaultName[]="regsetup.txt\0",*filename=defaultName;

	if (argc==2)
	{
		filename=argv[1];
	};

	char *myBuffer,*b,*end;
	DWORD NumberOfBytesRead,dwSize;
	HANDLE hFile = CreateFile(filename,	   // open setup.reg
                GENERIC_READ,              // open for reading 
                FILE_SHARE_READ,           // share for reading 
                NULL,                      // no security 
                OPEN_EXISTING,             // existing file only 
                FILE_ATTRIBUTE_NORMAL,     // normal file 
                NULL);                     // no attr. template 
	if (hFile == INVALID_HANDLE_VALUE) 
	{ 
		fprintf(stderr,
			"FILE NOT FOUND.\n\n"
			"REGSetup V1.0 coded by Kranf.\n\n"
			"   usage: REGSetup [filename]\n"
			"   [filename]: The data (reg file) to fusion to the registry. If\n"
			"               this parameter is not specified, the default filename\n"
			"               'regsetup.txt' will be used.\n\n"
			"REGSetup is a replacement tool for 'regedit'. However, there is a\n"
			"small difference with 'regedit': REGSetup replace all the '%%d'\n"
			"inside the key values with the current directory.\n\n"
			);
		exit(255);
	};
	printf("REGSetup V1.0 coded by Kranf.\n");
	dwSize = GetFileSize (hFile, NULL); 
	b=myBuffer=(char*)malloc(dwSize+1);
	end=b+dwSize;
	ReadFile(
		hFile,                // handle to file
		b,					  // data buffer
		dwSize,				  // number of bytes to read
		&NumberOfBytesRead,	  // number of bytes read
	    NULL				  // overlapped buffer
	);
	*end='[';
	CloseHandle(hFile);
	GetCurrentDirectory(5000,curDir);
	int i,p,n,curDirLength;
	HKEY hkMain;
	HKEY hkClass=NULL;
	DWORD dwDisp,tmp;
	char *mem,*name,*t1,*t2,*t;
	curDirLength=strlen(curDir);
	while (*b!='[') b++;
	while (b!=end)
	{
		b++; 
		p=0; hkMain=NULL;
		while (b[p]!=']') p++; b[p]='\0';
		if (strncmp(b,"HKEY_LOCAL_MACHINE",18)==0) 
		{
			hkMain=HKEY_LOCAL_MACHINE; b+=19;
		};
		if (strncmp(b,"HKEY_CLASSES_ROOT",17)==0) 
		{
			hkMain=HKEY_CLASSES_ROOT; b+=18;
		};
		if (strncmp(b,"HKEY_CURRENT_CONFIG",19)==0) 
		{
			hkMain=HKEY_CURRENT_CONFIG; b+=20;
		};
		if (strncmp(b,"HKEY_CURRENT_USER",17)==0) 
		{
			hkMain=HKEY_CURRENT_USER; b+=18;
		};
		if (strncmp(b,"HKEY_USERS",10)==0) 
		{
			hkMain=HKEY_USERS; b+=11;
		};
		if (strncmp(b,"HKEY_DYN_DATA",13)==0) 
		{
			hkMain=HKEY_DYN_DATA; b+=14;
		};
		if (hkMain==NULL)
		{
			fprintf(stderr,"error:impossible to create key.\n"); 
			exit(253);
		};
		RegCreateKeyEx(hkMain,
					   b,
					   0,
					   "",
					   REG_OPTION_NON_VOLATILE,
					   KEY_ALL_ACCESS,
					   NULL,
					   &hkClass,
					   &dwDisp);
		while (1)
		{
			while ((*b!='[')&&(*b!='"')) b++;
			if (*b=='[') break;
			if (*b=='"')
			{
				name=++b;
				while (*b!='"') b++; *b='\0';
				b+=2;
				switch (*b)
				{
				case '"':
					b++; t=b; n=0;
					while (*b!='"') 
					{
						if ((b[0]=='%')&&(b[1]=='d')) n++;
						b++; 
					};
					*b='\0';
					t1=t2=(char*)malloc(strlen(t)+n*curDirLength+1);
					while (*t!='\0')
					{
						if ((t[0]=='%')&&(t[1]=='d'))
						{
							strcpy(t1,curDir); t1+=curDirLength; t++;
						} else 
						{
							*t1=*t; t1++;
						};
						t++; 
					}
					*t1='\0';
					RegSetValueEx(hkClass,
								  name,
								  0,
								  REG_SZ,
								  (CONST BYTE*)t2,
								  strlen(t2)+1);
					free(t2);
					break;
				case 'd':
					b+=6;
					tmp=hexVal(b,8);
					RegSetValueEx(hkClass,
								  name,
								  0,
								  REG_DWORD,
								  (CONST BYTE*)&tmp,
								  4);
					break;
				case 'h':
					t=b+4; b+=6; n=1;
					while (*b==',') { b+=3; n++; };
					mem=(char*)malloc(n);
					for (i=0; i<n; i++)
					{
						mem[i]=(char)hexVal(t,2);
						t+=3;
					};
					RegSetValueEx(hkClass,
								  name,
								  0,
								  REG_BINARY,
								  (CONST BYTE*)mem,
								  n);
					break;
					free(mem);
				}
			};
		};
	};
	free(myBuffer);
	fprintf(stderr,"All OK.\n");
	return 0;
}