#include <memory.h> // for memmove (microsoft bug)
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

//#include <crtdbg.h> // to debug

#include "mathutil.h"

double rand1()
{
    return ((double)rand())/(RAND_MAX+1.0);
}

void initRandom()
{
//    timeval tv;
//    gettimeofday(&tv,NULL);
//    srand(tv.tv_usec);
//     struct timeb t;
//     ftime(&t);
//     srand(t.millitm);
//     printf("seed for random number generation: %i\n",t.millitm);
	srand( (unsigned)time( NULL ) );

}

void error(char *s)
{
   printf("Error due to %s.", s);
   exit(255);
};

/* =======================table object=============================*/

Table::Table(int _m,int _n) //m=ligne; n=colonne
{
	int i;
    n=_n; m=_m; extention=_m;
	double *t;
	p=(double**)malloc(_n*sizeof(double*));
	if (m>0)
	{
    	t=(double*)malloc(_n*_m*sizeof(double));
	    for (i=0; i<_n; i++, t+=_m) p[i]=t;
	};
};

Table::Table(char *filename,int _n)
{
    int j,mx=0;
    n=_n; m=0; extention=0;
	double *tmp=(double *)malloc(_n*sizeof(double));
	p=(double**)malloc(_n*sizeof(double*));
	
    FILE *f=fopen(filename,"r");
	while (fread(tmp,_n*sizeof(double),1,f))
	{
	   extend();
	   for (j=0; j<_n; j++) p[j][mx]=tmp[j];
	   mx++;
	}
	free(tmp);
	fclose(f);
}

void Table::save(char *filename,char ascii)
{
    int i,j;
    FILE *f;
    if (ascii) 
    {
        f=fopen(filename,"w");
        for (i=0; i<m; i++)
        {
            for (j=0; j<n; j++)
                fprintf(f,"%1.10f ",p[j][i]);
            fprintf(f,"\n");
        }
    } else
    {
        f=fopen(filename,"wb");
        for (i=0; i<m; i++)
            for (j=0; j<n; j++)
                fwrite(&(p[j][i]),sizeof(double),1,f);
    };
    fclose(f);
}

void Table::extend()
{
	if (extention==m)
	{	
        int n=this->n,mo=m,i;
	    double *tmp,*tmp2,**tmp3=p,*tmp4=*tmp3;

        extention+=100;
	
		tmp=(double *)calloc(n*extention,sizeof(double));
		if (tmp==NULL) error("memory allocation error");

		tmp2=tmp;
		for (i=0; i<n; i++)
		{
 		    tmp3[i]=tmp2;
 		    tmp2+=extention;
		};

        if (mo!=0)
        {
    		tmp2=tmp4;
    		for (i=0; i<n; i++)
		    { 
		        memmove(tmp,tmp2,mo*sizeof(double));
  		        tmp+=extention;
		        tmp2+=mo;
		    };
            free(tmp4);
        };
	};
	m++;
}

void Table::exactshape()
{
	int n=this->n,m=this->m,i;
	double *tmp,*tmp2;
	if (extention!=m)
	{
		tmp=*p;
		for (i=1; i<n; i++, tmp+=m) p[i]=tmp;

		tmp=tmp2=*p;
		i=1;
		while(i<n)
		{
		    tmp2+=extention;
		    tmp+=m;
		    memmove(tmp,tmp2,m*sizeof(double));
		    i++;
		};

		tmp=(double*)realloc(*p,n*m*sizeof(double));
		if (tmp!=*p)
		    for (i=0; i<n; i++, tmp+=m) p[i]=tmp;
		extention=m;
	};
};

Table::~Table()
{
    free(p[0]); free(p);
};

double * Table::operator [](int i)
{
    return p[i];
};

/* =======================vector object=============================*/

Vector::Vector(int _n): n(_n), extention(_n)
{
    p=(double*)malloc(_n*sizeof(double)); 
};

Vector::Vector(Vector *v): n(v->n), extention(v->n)
{
    p=(double *)malloc(n*sizeof(double));
    memcpy(p,v->p,n*sizeof(double));
}

void Vector::extend()
{	
	if (extention==n)
	{
    	extention+=100;
		p=(double*)realloc(p,extention*sizeof(double));
		if (p==NULL) error("memory allocation error");	
	};
	n++;
};

void Vector::exactshape()
{
	if (extention!=0)
	{
		p=(double*)realloc(p,n*sizeof(double));
		extention=0;
	};
};

Vector::~Vector()
{
    free(p);
};

double &Vector::operator [](int i)
{
    return p[i];
}
/* =======================vectorI object=============================*/

VectorI::VectorI(int _n): n(_n), extention(_n)
{
    p=(int *)malloc(_n*sizeof(int));
};

VectorI::~VectorI()
{
    free(p);
};

VectorI::VectorI(VectorI *v): n(v->n), extention(v->n)
{
    p=(int *)malloc(n*sizeof(int));
    memcpy(p,v->p,n*sizeof(int));
}

void VectorI::extend()
{	
	if (extention==n)
	{
    	extention+=100;
		p=(int*)realloc(p,extention*sizeof(int));
		if (p==NULL) error("memory allocation error");	
	};
	n++;
};

void VectorI::exactshape()
{
	if (extention!=0)
	{
		p=(int*)realloc(p,n*sizeof(int));
		extention=0;
	};
};

int &VectorI::operator [](int i)
{
    return p[i];
}
