// fullscreenView.cpp : implementation of the CFullscreenView class
//

#include "stdafx.h"
#include "fullscreen.h"

#include "fullscreenDoc.h"
#include "fullscreenView.h"
#include "SizeDlg.h"

#define SOURCE_TEXT 300

//#include <atlbase.h>
#include <dshow.h>
#include <AFXPRIV.H> // for uses_conversion

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFullscreenView

IMPLEMENT_DYNCREATE(CFullscreenView, CView)

BEGIN_MESSAGE_MAP(CFullscreenView, CView)
	//{{AFX_MSG_MAP(CFullscreenView)
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_VIDEO_SOURCE1, OnVideoSource1)
	ON_COMMAND(ID_VIDEO_SOURCE0, OnVideoSource0)
	ON_COMMAND(ID_VIDEO_SOURCE2, OnVideoSource2)
	ON_COMMAND(ID_VIDEO_SOURCE3, OnVideoSource3)
	ON_COMMAND(ID_VIDEO_SOURCE4, OnVideoSource4)
	ON_COMMAND(ID_VIDEO_SOURCE5, OnVideoSource5)
	ON_COMMAND(ID_VIDEO_SOURCE6, OnVideoSource6)
	ON_COMMAND(ID_VIDEO_SOURCE7, OnVideoSource7)
	ON_COMMAND(ID_VIDEO_SOURCE8, OnVideoSource8)
	ON_COMMAND(ID_VIDEO_SOURCE9, OnVideoSource9)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_COMMAND(ID_CONTEXTMENU_1024X768, On1024x768)
	ON_COMMAND(ID_CONTEXTMENU_800X600, On800x600)
	ON_COMMAND(ID_CONTEXTMENU_FULLSCREEN, OnFullscreen)
	ON_COMMAND(ID_CONTEXTMENU_PROPERTIES, OnProperties)
	ON_COMMAND(ID_CONTEXTMENU_FORMATPROPERTIES, OnFormatproperties)
	ON_COMMAND(ID_CONTEXTMENU_640X480, On640x480)
	ON_UPDATE_COMMAND_UI(ID_CONTEXTMENU_1024X768, OnUpdate1024x768)
	ON_UPDATE_COMMAND_UI(ID_CONTEXTMENU_640X480, OnUpdate640x480)
	ON_UPDATE_COMMAND_UI(ID_CONTEXTMENU_800X600, OnUpdate800x600)
	ON_UPDATE_COMMAND_UI(ID_CONTEXTMENU_FULLSCREEN, OnUpdateFullscreen)
	ON_UPDATE_COMMAND_UI(ID_VIDEO_SOURCE0, OnUpdateVideoSource0)
	ON_UPDATE_COMMAND_UI(ID_VIDEO_SOURCE1, OnUpdateVideoSource1)
	ON_UPDATE_COMMAND_UI(ID_VIDEO_SOURCE2, OnUpdateVideoSource2)
	ON_UPDATE_COMMAND_UI(ID_VIDEO_SOURCE3, OnUpdateVideoSource3)
	ON_UPDATE_COMMAND_UI(ID_VIDEO_SOURCE4, OnUpdateVideoSource4)
	ON_UPDATE_COMMAND_UI(ID_VIDEO_SOURCE5, OnUpdateVideoSource5)
	ON_UPDATE_COMMAND_UI(ID_VIDEO_SOURCE6, OnUpdateVideoSource6)
	ON_UPDATE_COMMAND_UI(ID_VIDEO_SOURCE7, OnUpdateVideoSource7)
	ON_UPDATE_COMMAND_UI(ID_VIDEO_SOURCE8, OnUpdateVideoSource8)
	ON_UPDATE_COMMAND_UI(ID_VIDEO_SOURCE9, OnUpdateVideoSource9)
	ON_COMMAND(ID_CONTEXTMENU_LINEIN, OnLinein)
	ON_COMMAND(ID_CONTEXTMENU_MICROPHONE, OnMicrophone)
	ON_UPDATE_COMMAND_UI(ID_CONTEXTMENU_LINEIN, OnUpdateLinein)
	ON_UPDATE_COMMAND_UI(ID_CONTEXTMENU_MICROPHONE, OnUpdateMicrophone)
	ON_UPDATE_COMMAND_UI(ID_CONTEXTMENU_OTHER, OnUpdateOther)
	ON_COMMAND(ID_CONTEXTMENU_OTHER, OnOther)
	ON_COMMAND(ID_CONTEXTMENU_TOP, OnTop)
	ON_UPDATE_COMMAND_UI(ID_CONTEXTMENU_TOP, OnUpdateTop)
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_WM_MOUSEWHEEL()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFullscreenView construction/destruction

CFullscreenView::CFullscreenView()
						:pGraph(NULL),pMediaControl(NULL),pVidWin(NULL)
                     ,pBuilder(NULL)
					 , m_bBind(FALSE),pEvent(NULL)
                     ,m_index(0)
                     ,m_micro(NULL)
                     ,m_line(NULL)
                     ,m_onTop(true)
                     ,m_bMouseDown(false)
                     ,m_x(0) , m_y(0)
                     ,m_nRep(0)
{
    sources = (char*) malloc(10*SOURCE_TEXT*sizeof(char));
    memset((void*)sources,0,10*SOURCE_TEXT*sizeof(char));

    m_foundSources = getStrSource();

   CFullscreenApp *f=(CFullscreenApp *)AfxGetApp( );

   //OnFullscreen(); can not be used bcs window not yet created
   m_onTop= f->top?true:false;
   m_winHeight = f->height;
   m_winWidth = f->width;
   m_x = f->x0;
   m_y = f->y0;

   SetSizeType();
   SetRatio();

   if (f->audio)
   {
       int ret;

    	m_micro = new AudioMute(f);
	    m_line = new AudioMute(f);

        // Init returns  1 OK, if returns  0 failure
        ret=m_micro->Init(MIXERLINE_COMPONENTTYPE_DST_SPEAKERS,
	                 MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE,
	                 MIXERCONTROL_CONTROLTYPE_MUTE, 0 );

        if (!ret) 
        {
            delete m_micro; 
            m_micro=NULL; 
            MessageBox("no microphone will be available!!!");
        }

        ret = m_line->Init(MIXERLINE_COMPONENTTYPE_DST_SPEAKERS,
	                 MIXERLINE_COMPONENTTYPE_SRC_LINE,
	                 MIXERCONTROL_CONTROLTYPE_MUTE, 0 );
        if (!ret) 
        {
            delete m_line; 
            m_line=NULL;
            MessageBox("no linein will be available!!!");
        }
        
        if (m_micro) m_micro->SetValue(f->micro);
        if (m_line ) m_line->SetValue(f->line);
        if ((!m_micro)&&(!m_line)) f->audio = FALSE;
   }

}

CFullscreenView::~CFullscreenView()
{
    free(sources);
   CFullscreenApp *f=(CFullscreenApp *)AfxGetApp( );

   if (m_micro) {m_micro->RestoreOrigValue();delete m_micro;m_micro=NULL;}
   if (m_line)  {m_line->RestoreOrigValue(); delete m_line; m_line=NULL;}

}

/////////////////////////////////////////////////////////////////////////////
// CFullscreenView drawing

void CFullscreenView::OnDraw(CDC* pDC)
{
	CFullscreenDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
}

/////////////////////////////////////////////////////////////////////////////
// CFullscreenView diagnostics

#ifdef _DEBUG
void CFullscreenView::AssertValid() const
{
	CView::AssertValid();
}

void CFullscreenView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CFullscreenDoc* CFullscreenView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CFullscreenDoc)));
	return (CFullscreenDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFullscreenView message handlers

//index if no sources are not yet filled in
#define INDEX_MICRO 9
#define INDEX_LINE  10

void CFullscreenView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
    char buf[3000];
//    int nbr_not_devices;
    CFullscreenApp *f=(CFullscreenApp *)AfxGetApp( );
    // We might need to adjust the origination point for the keyboard context menu
    if(point.x == -1 && point.y == -1)
    {
        CRect rect;
        GetClientRect(&rect);
        point = rect.TopLeft();
        point.Offset(5,5);
        ClientToScreen(&point);
    }

    // Load the top level menu from the resource we created
    CMenu myMenu;
    myMenu.LoadMenu(IDR_POPUP_MENU);

    // Now extract the (one and only) popup menu item from this menu resource
    CMenu* myPopup = myMenu.GetSubMenu(0);



    int i,index,count = myPopup->GetMenuItemCount();
    for (i=0;i<count-15;i++)
        myPopup->DeleteMenu(0,MF_BYPOSITION);

    //delete the audio
    if(!f->audio)
        for (i=0;i<3;i++)
            myPopup->DeleteMenu(INDEX_MICRO-1,MF_BYPOSITION);
    else
    {
        if (!m_micro) 
            myPopup->DeleteMenu(INDEX_MICRO,MF_BYPOSITION);
        if (!m_line)  
            myPopup->DeleteMenu(INDEX_LINE,MF_BYPOSITION);
    }

    index=0;
    if(sources[SOURCE_TEXT*index]!=NULL)
        myPopup->InsertMenu(0,MF_BYPOSITION,MF_SEPARATOR);

    while(sources[SOURCE_TEXT*index]!=NULL)
    {
        sprintf(buf, "%i - %s\t%d",index+1,&sources[SOURCE_TEXT*index],index+1);
        myPopup->InsertMenu(index,MF_BYPOSITION,(ID_VIDEO_SOURCE0+index),buf);
        index++;
    }

    // Let's display the menu!
    myPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON, point.x, point.y,
                               AfxGetMainWnd(), NULL);
}

int CFullscreenView::getStrSource()
{
//--------------- video camera ------------------------
    USES_CONVERSION;
   CoInitialize(NULL);
	
	int hr,index=0;
	ICreateDevEnum *pSysDevEnum = NULL;
	hr=CoCreateInstance(CLSID_SystemDeviceEnum, 
		NULL, CLSCTX_INPROC, IID_ICreateDevEnum, 
		(void **)&pSysDevEnum);
	if (hr != S_OK)
	{
		AfxMessageBox("Error Creating Device Enumerator");
		CoUninitialize();
		return 0;
	}

    
    IEnumMoniker *pEnumCat = NULL;
	hr=pSysDevEnum->CreateClassEnumerator(CLSID_VideoInputDeviceCategory, &pEnumCat, 0);

    if (hr != S_OK)
	{
    	AfxMessageBox("Sorry, you have no video capture hardware");
		pSysDevEnum->Release();
		CoUninitialize();
		return 0;
	}

    pEnumCat->Reset();

    IMoniker *pMoniker;
	ULONG cFetched;
	IBaseFilter *pSrc = NULL;

    index =0;

	while(pEnumCat->Next(1, &pMoniker, &cFetched) == S_OK)
	{        
        IPropertyBag *pPropBag;
		hr = pMoniker->BindToStorage(0, 0, IID_IPropertyBag, (void **)&pPropBag);

        if(SUCCEEDED(hr)) 
        {

		    // To retrieve the friendly name of the filter:
		    VARIANT varName;
		    varName.vt = VT_BSTR;
			//VT_BSTR :A string was passed; it is stored in bstrVal. 
			//This pointer must be obtained and freed by the BSTR functions. 

    		hr=pPropBag->Read(L"FriendlyName", &varName, 0);
	        if (hr == NOERROR) 
            {
                strcpy(&sources[SOURCE_TEXT*index],W2T((BSTR)varName.bstrVal));
                index++;
          		SysFreeString(varName.bstrVal);
            }
    		pPropBag->Release();
        }
		pMoniker->Release();

    }
	pEnumCat->Release();
    pSysDevEnum->Release();
    CoUninitialize();
    return index;
}


bool CFullscreenView::startVideo(int index)
{
	if ((index<0)||(index >= m_foundSources)) index =0; 
    m_index = index;
    USES_CONVERSION;

	TCHAR message[300];
    
	int hr;
	// Create the filter graph.
	hr=CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC,
		IID_IGraphBuilder, (void **)&pGraph);

	// Create the capture graph builder.
	hr=CoCreateInstance(CLSID_CaptureGraphBuilder2, NULL, CLSCTX_INPROC, 
		IID_ICaptureGraphBuilder2, (void **)&pBuilder);

	pBuilder->SetFiltergraph(pGraph);    

	pGraph->QueryInterface(IID_IMediaEvent, (void **)&pEvent);
	pGraph->QueryInterface(IID_IMediaControl, (void **)&pMediaControl);

    HWND g_hwnd=(HWND)this->m_hWnd;
    hr=pGraph->QueryInterface(IID_IVideoWindow, (void **)&pVidWin);

//---------------  bind to choosen device  ----------------------

	ICreateDevEnum *pSysDevEnum = NULL;
	hr=CoCreateInstance(CLSID_SystemDeviceEnum, 
		NULL, CLSCTX_INPROC, IID_ICreateDevEnum, 
		(void **)&pSysDevEnum);

	IEnumMoniker *pEnumCat = NULL;
	hr=pSysDevEnum->CreateClassEnumerator(CLSID_VideoInputDeviceCategory, &pEnumCat, 0);

	IMoniker *pMoniker;
	ULONG cFetched;
	IBaseFilter *pSrc = NULL;
	while(pEnumCat->Next(1, &pMoniker, &cFetched) == S_OK)
	{
		IPropertyBag *pPropBag;
		pMoniker->BindToStorage(0, 0, IID_IPropertyBag, (void **)&pPropBag);

		// To retrieve the friendly name of the filter:
		VARIANT varName;
		varName.vt = VT_BSTR;
		pPropBag->Read(L"FriendlyName", &varName, 0);
		// Display the name in your UI somehow.
		if (strcmp( W2T((BSTR)varName.bstrVal),&sources[index*SOURCE_TEXT])==0)
		{
			// To create an instance of the filter:
			pMoniker->BindToObject(NULL, NULL, IID_IBaseFilter, (void**)&pSrc);
			m_bBind=TRUE;
		}
		SysFreeString(varName.bstrVal);
    
		// Clean up.
		pPropBag->Release();
		pMoniker->Release();
	}
	pEnumCat->Release();
	pSysDevEnum->Release();

	if (!pSrc)
	{

		wsprintf(message,TEXT("Can't find source: %s\n"),&sources[index*SOURCE_TEXT]);
		AfxMessageBox(message);
		return 0;
	}

//------  bind to first device found if not found choosen device  -------------
	if (!m_bBind)
	{
		// Create the system device enumerator.
		ICreateDevEnum *pDevEnum = NULL;
		hr=CoCreateInstance(CLSID_SystemDeviceEnum, NULL, CLSCTX_INPROC, 
			IID_ICreateDevEnum, (void **)&pDevEnum);

		// Create an enumerator for video capture devices.
		IEnumMoniker *pClassEnum = NULL;
		hr=pDevEnum->CreateClassEnumerator(CLSID_VideoInputDeviceCategory, &pClassEnum, 0);

		ULONG cFetched;
		IMoniker *pMoniker = NULL;
		IBaseFilter *pSrc = NULL;
		if (pClassEnum->Next(1, &pMoniker, &cFetched) == S_OK)
		{
			// Bind the first moniker to a filter object.
			hr=pMoniker->BindToObject(0, 0, IID_IBaseFilter, (void**)&pSrc);
			m_bBind=TRUE;
			pMoniker->Release();
		}
		pClassEnum->Release();
		pDevEnum->Release();
	};

//------------------- build the graph -----------------------------
	if (m_bBind)
	{

		hr = pGraph->AddFilter(pSrc, L"Video Capture");

		hr=pBuilder->RenderStream(
				&PIN_CATEGORY_PREVIEW, 
				&MEDIATYPE_Video, 
				pSrc, 
				NULL,   // No compression filter.
				NULL    // Default renderer.
			);
//		long error=GetLastError();

		if ((hr != S_OK) && (hr!=262782))//262782 = insersion of an splitter
		{
		    hr = pBuilder->RenderStream(
				&PIN_CATEGORY_CAPTURE, 
				&MEDIATYPE_Video, 
				pSrc, 
				NULL,   // No compression filter.
				NULL    // Default renderer.
			);
            if (hr != S_OK)
            {
        		pSrc->Release();
			    AfxMessageBox("Check if your Camera/Capture device is connected!!!\n"
                          "Plug it and re-select it in the context menu\n"
                          "If the device is connected,\n check if it is not running else where");
			    return false;
            }
		}
   		pSrc->Release();

	}
//------------- set windows position ------------------

    RECT grc;
    GetClientRect(&grc);
    hr=pVidWin->put_Owner((OAHWND)g_hwnd);
    hr=pVidWin->put_WindowStyle(WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS);
    pVidWin->SetWindowPosition(0, 0, m_winWidth, m_winHeight);

//------------- Run the graph ------------------------
    pMediaControl->Run();
    return true;
}


bool CFullscreenView::ChangeToSource(int index)
{
    if (!m_foundSources)
        return true;
    stopVideo();
    startVideo(index);
    return true;
}

void CFullscreenView::OnVideoSource0() {ChangeToSource(0);}
void CFullscreenView::OnVideoSource1() {ChangeToSource(1);}
void CFullscreenView::OnVideoSource2() {ChangeToSource(2);}
void CFullscreenView::OnVideoSource3() {ChangeToSource(3);}
void CFullscreenView::OnVideoSource4() {ChangeToSource(4);}
void CFullscreenView::OnVideoSource5() {ChangeToSource(5);}
void CFullscreenView::OnVideoSource6() {ChangeToSource(6);}
void CFullscreenView::OnVideoSource7() {ChangeToSource(7);}
void CFullscreenView::OnVideoSource8() {ChangeToSource(8);}
void CFullscreenView::OnVideoSource9() {ChangeToSource(9);}

int CFullscreenView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
    if (!m_foundSources)
        return 0;

    CoInitialize(NULL);
    CFullscreenApp *f=(CFullscreenApp *)AfxGetApp( );
    return startVideo(f->deviceNbr);
}

void CFullscreenView::OnDestroy() 
{
    if (m_foundSources)
    {
        stopVideo();
        CoUninitialize();
    }

	CView::OnDestroy();
	
}

bool CFullscreenView::stopVideo()
{
	if (pMediaControl) 
        pMediaControl->Stop();

	if (pVidWin)
	{
		pVidWin->put_Visible(OAFALSE);
		pVidWin->put_Owner(NULL);   
		pVidWin->Release();
        pVidWin = NULL;
	}
    if (pMediaControl){pMediaControl->Release();pMediaControl = NULL;}
    if (pEvent)  {pEvent->Release();   pEvent   = NULL;}
	if (pGraph)  {pGraph->Release();   pGraph   = NULL;}
    if (pBuilder){pBuilder->Release(); pBuilder = NULL;}
    return true;
}

BOOL CFullscreenView::PreTranslateMessage(MSG* pMsg) 
{
	if ((pMsg->message==WM_LBUTTONUP)&&(m_foundSources)) pVidWin->SetWindowPosition(0, 0, m_winWidth, m_winHeight);

    if (pMsg->message==WM_MOUSEMOVE) OnMouseMove(pMsg->wParam, pMsg->lParam);
	if (pMsg->message==WM_LBUTTONDOWN)OnLButtonDown(pMsg->wParam, pMsg->lParam);
	if (pMsg->message==WM_LBUTTONUP)OnLButtonUp(pMsg->wParam, pMsg->lParam);
    return CView::PreTranslateMessage(pMsg);
}

void CFullscreenView::On640x480()    {SetScreenSize(640,480); SetRatio();}
void CFullscreenView::On800x600()    {SetScreenSize(800,600); SetRatio();}
void CFullscreenView::On1024x768()   {SetScreenSize(1024,768);SetRatio();}
void CFullscreenView::OnFullscreen() 
{
    m_x=0;m_y=0;
    SetScreenSize(GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN));
    SetRatio();
}

void CFullscreenView::OnOther() 
{
    SizeDlg *d = new SizeDlg(m_winHeight,m_winWidth);
    
    d->DoModal();
    if (d->m_ok)
    {
        SetScreenSize(d->m_width,d->m_height);
        SetRatio();
    }
    delete d;
	
}
void CFullscreenView::SetScreenPosition(int x, int y)
{
    m_x=x;
    m_y=y;
    SetScreen();
}


void CFullscreenView::SetScreenSize(int x, int y)
{
    if ((x < 4)||(y < 3))
    {
        MessageBox("Image size is to small!!!");
        return;
    }
    m_winWidth = x;
    m_winHeight = y;
    SetScreen();
}

void CFullscreenView::SetScreen()
{
    if (m_onTop)
        GetTopLevelFrame()->SetWindowPos(&wndTopMost,m_x-1,m_y-1,m_winWidth +3,m_winHeight + 3,SWP_SHOWWINDOW);
    else
        GetTopLevelFrame()->SetWindowPos(&wndNoTopMost,m_x-1,m_y-1,m_winWidth +3,m_winHeight + 3,SWP_SHOWWINDOW);

    if (m_foundSources) pVidWin->SetWindowPosition(0, 0, m_winWidth, m_winHeight);    	
    
    SetSizeType();
}

void CFullscreenView::OnProperties() 
{
  if (!m_foundSources) return;
  IFilterGraph  *pifg  = NULL;
  IBaseFilter   *pifPP = NULL;
  ISpecifyPropertyPages *pispp = NULL;

  pGraph->QueryInterface(IID_IFilterGraph, (void **)&pifg);
   if (SUCCEEDED(pifg->FindFilterByName(L"Video Capture", &pifPP)))
   {
	   if (FAILED(pifPP->QueryInterface(IID_ISpecifyPropertyPages, (void **)&pispp)))
       {
           pifg->Release();
           pifPP->Release();
           MessageBox("No property page found!"); 
           return;
       }
		CAUUID caGUID;
		pispp->GetPages(&caGUID);
		pispp->Release();

        GetTopLevelFrame()->SetWindowPos(&wndNoTopMost,m_x-1,m_y-1,m_winWidth +3,m_winHeight + 3,SWP_NOZORDER|SWP_NOACTIVATE);//SWP_SHOWWINDOW);
//Create a modal dialog box to display the filter's property page. 

		OleCreatePropertyFrame(GetTopLevelFrame()->m_hWnd ,
            0,
            0,
            L"Source",          // Caption for the dialog box
            1,                  // Number of filters
            (IUnknown **)&pifPP,  // Pointer to the filter whose property 
                                // Pages are being displayed. This can 
                                // be an array of pointers if more than
                                // one filter's property pages are to 
                                // be displayed. Note that only 
                                // properties common to all the filters 
                                // can be displayed on the same modal 
                                // dialog.
            caGUID.cElems,      // Number of property pages
            caGUID.pElems,      // Pointer to property page CLSIDs
            0,
            0,
            NULL);
	    CoTaskMemFree(caGUID.pElems);

        SetScreen();

		pifPP->Release();
   }
   else MessageBox("No property page found!"); 

   pifg->Release();
}


void CFullscreenView::OnFormatproperties() 
{
    if (!m_foundSources) return;
    IFilterGraph  *pifg  = NULL;
    IBaseFilter   *pVCap = NULL;
    ISpecifyPropertyPages *pSpec = NULL;
	IPin *pPinOut=NULL; // Video port pin on capture filter. 
    
    pMediaControl->Stop();
    HRESULT hr;
	pGraph->QueryInterface(IID_IFilterGraph, (void **)&pifg);
    if (SUCCEEDED(pifg->FindFilterByName(L"Video Capture", &pVCap)))
    {
       	IAMStreamConfig *pSC;

        if(FAILED(pBuilder->FindInterface(&PIN_CATEGORY_PREVIEW,
				&MEDIATYPE_Video, pVCap,
				IID_IAMStreamConfig, (void **)&pSC)))
    		    
                if(FAILED(pBuilder->FindInterface(&PIN_CATEGORY_CAPTURE,
				        &MEDIATYPE_Video, pVCap,
				        IID_IAMStreamConfig, (void **)&pSC)))
                {
                    pifg->Release();
                    pVCap->Release();
                    return;
                }

		ISpecifyPropertyPages *pSpec;
		CAUUID cauuid;
    	if(SUCCEEDED(pSC->QueryInterface(IID_ISpecifyPropertyPages,(void **)&pSpec)))
        {
            //if there is an error message it will be in front of the dialog and fullscreen window
            GetTopLevelFrame()->SetWindowPos(&wndNoTopMost,m_x-1,m_y-1,m_winWidth +3,m_winHeight + 3,SWP_SHOWWINDOW);
            
            hr = pSpec->GetPages(&cauuid);
            
            hr = OleCreatePropertyFrame(GetTopLevelFrame()->m_hWnd,
                    30, 30, L"Format", 1,
                    (IUnknown **)&pSC, cauuid.cElems,
		            (GUID *)cauuid.pElems, 0, 0, NULL);
		    CoTaskMemFree(cauuid.pElems);
		    pSpec->Release();

            SetScreen();
		}
        else MessageBox("No property page found!");
		pSC->Release();
        pVCap->Release();

   }
	else MessageBox("No property page found!"); 	
	pMediaControl->Run();
    pifg->Release();
}


void CFullscreenView::OnUpdate1024x768(CCmdUI* pCmdUI){pCmdUI->SetCheck(m_size == s1024x768);}
void CFullscreenView::OnUpdate640x480(CCmdUI* pCmdUI) {pCmdUI->SetCheck(m_size == s640x480);}
void CFullscreenView::OnUpdate800x600(CCmdUI* pCmdUI) {pCmdUI->SetCheck(m_size == s800x600);}
void CFullscreenView::OnUpdateFullscreen(CCmdUI* pCmdUI){pCmdUI->SetCheck(m_size == fullscreen);}
void CFullscreenView::OnUpdateOther(CCmdUI* pCmdUI)   {pCmdUI->SetCheck(m_size == custom);}

void CFullscreenView::OnUpdateVideoSource0(CCmdUI* pCmdUI) {pCmdUI->SetCheck(m_index == 0);}
void CFullscreenView::OnUpdateVideoSource1(CCmdUI* pCmdUI) {pCmdUI->SetCheck(m_index == 1);}
void CFullscreenView::OnUpdateVideoSource2(CCmdUI* pCmdUI) {pCmdUI->SetCheck(m_index == 2);}
void CFullscreenView::OnUpdateVideoSource3(CCmdUI* pCmdUI) {pCmdUI->SetCheck(m_index == 3);}
void CFullscreenView::OnUpdateVideoSource4(CCmdUI* pCmdUI) {pCmdUI->SetCheck(m_index == 4);}
void CFullscreenView::OnUpdateVideoSource5(CCmdUI* pCmdUI) {pCmdUI->SetCheck(m_index == 5);}
void CFullscreenView::OnUpdateVideoSource6(CCmdUI* pCmdUI) {pCmdUI->SetCheck(m_index == 6);}
void CFullscreenView::OnUpdateVideoSource7(CCmdUI* pCmdUI) {pCmdUI->SetCheck(m_index == 7);}
void CFullscreenView::OnUpdateVideoSource8(CCmdUI* pCmdUI) {pCmdUI->SetCheck(m_index == 8);}
void CFullscreenView::OnUpdateVideoSource9(CCmdUI* pCmdUI) {pCmdUI->SetCheck(m_index == 9);}

void CFullscreenView::OnUpdateLinein(CCmdUI* pCmdUI)       {pCmdUI->SetCheck(m_line->GetValue());}
void CFullscreenView::OnUpdateMicrophone(CCmdUI* pCmdUI)   {pCmdUI->SetCheck(m_micro->GetValue());}

void CFullscreenView::OnLinein()     {m_line->OnClicked_();}
void CFullscreenView::OnMicrophone() {m_micro->OnClicked_();}

void CFullscreenView::OnTop() 
{
    m_onTop=!m_onTop;
    SetScreen();
}

void CFullscreenView::OnUpdateTop(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck(m_onTop);	
}


#define LEFT_KEY    37
#define UP_KEY      38
#define RIGHT_KEY   39
#define DOWN_KEY    40

#define HOME_KEY    36

void CFullscreenView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
//    char buf[100];
//    sprintf(buf,"char %d",nChar);
//    MessageBox(buf);
    if (nChar == HOME_KEY)
    {
        SetScreenPosition(0,0);
        return;
    }

    if (m_nRep<10) m_nRep++;
    switch(nChar)
    {
    case LEFT_KEY: m_x-=m_nRep;break;
    case RIGHT_KEY: m_x+=m_nRep;break;
    case DOWN_KEY: m_y+=m_nRep;break;
    case UP_KEY: m_y-=m_nRep;break;
    default: return;
    }

    SetScreen();
	
	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CFullscreenView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
    m_nRep=0;

	CView::OnKeyUp(nChar, nRepCnt, nFlags);
}

#define MAX(x,y) (x>0?(x>y?x:y):(x<y?x:y))

BOOL CFullscreenView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt) 
{
    double x, y;
    double dx = MAX( (zDelta * ((double)m_winWidth)/((double)GetSystemMetrics(SM_CXSCREEN)) ),1.5);//must be > 4./3.

    x = m_winWidth + dx;
    y = x / m_ratio;

    TRACE("x: %d->%d, y: %d->%d\n",m_x,(int)x,m_y,(int)y);

    if ( (x > 4) && (y > 3) )
        SetScreenSize((int)x,(int) y);

    return CView::OnMouseWheel(nFlags, zDelta, pt);
}

void CFullscreenView::SetSizeType()
{

   if (m_winWidth == GetSystemMetrics(SM_CXSCREEN) && 
       m_winHeight == GetSystemMetrics(SM_CYSCREEN) &&
       m_x == 0 && m_y == 0)
                                                        {m_size = fullscreen;}
   else if (m_winWidth == 640 && m_winHeight == 480)    {m_size = s640x480;}
   else if (m_winWidth == 800 && m_winHeight == 600)    {m_size = s800x600;}
   else if (m_winWidth == 1024 && m_winHeight == 768)   {m_size = s1024x768;}
   else                                                 {m_size = custom; }

}
void CFullscreenView::SetRatio()
{   
    m_ratio = ((double)m_winWidth) / ((double)m_winHeight);
}

void CFullscreenView::OnLButtonDown(UINT nFlags, CPoint point) 
{
    
//    char buf[100];
//    sprintf(buf,"point %d,%d",point.x,point.y);
//    MessageBox(buf);
    SetCapture();
//    ::SetCursor ( ::LoadCursor ( AfxGetInstanceHandle (), IDC_SIZE  ) );
//    TRACE("point %4d %4d, m_x, m_y %4d %4d\n"
//            ,point.x,point.y,m_x,m_y);
    if (!m_bMouseDown)
    {
        m_mouseDownPoint=point;
        m_mouseDownPointOrigine.x=m_x;
        m_mouseDownPointOrigine.y=m_y;
    }
    m_bMouseDown = true;
    CView::OnLButtonDown(nFlags, point);
}

void CFullscreenView::OnLButtonUp(UINT nFlags, CPoint point) 
{
//    MessageBox("up");
//    ::SetCursor ( ::LoadCursor ( AfxGetInstanceHandle (), IDC_ARROW ) );
    m_bMouseDown = false;
	ReleaseCapture();
    m_nRep2=0;
    CView::OnLButtonUp(nFlags, point);
}


void CFullscreenView::OnMouseMove(UINT nFlags, CPoint point) 
{
    m_nRep2++;
    if ((m_bMouseDown) && (m_nRep2%2 == 0))
    {

        int dx = point.x-m_mouseDownPoint.x;
        int dy = point.y-m_mouseDownPoint.y;
//        TRACE("point %4d %4d, mouse pointdown %4d %4d, delta %3d %3d\n"
//            ,point.x,point.y,m_mouseDownPoint.x,m_mouseDownPoint.y,dx,dy);
        
        SetScreenPosition(m_x+=dx,m_y+=dy);
    }
	CView::OnMouseMove(nFlags, point);
}
