function [out,error] = OF_SpeedReducerNLC(isGradNeeded, J, x)
if(isGradNeeded == 0)
    % Note that: x is feasible <=> NLConstraint >= 0
    % This is different from the NOMADm implementation, so we need to change the sign
    switch J
        case 1,
        out=1-27/(x(1)*x(2)^2*x(3));
        case 2,
        out=1-397.5/(x(1)*x(2)^2*x(3)^2);
        case 3,
        out=1-1.93*x(4)^3/(x(2)*x(3)*x(6)^4);
        case 4,
        out=1-1.93*x(5)^3/(x(2)*x(3)*x(7)^4);
        case 5,
        out=1-((745*x(4)/(x(2)*x(3)))^2+16.9e6)^0.5/(110.0*x(6)^3);
        case 6,
        out=1-((745*x(5)/(x(2)*x(3)))^2+157.5e6)^0.5/(85.0*x(7)^3);
        case 7,
        out=1-x(2)*x(3)/40;
        case 8,
        out=1-5*x(2)/x(1);
        case 9,
        out=1-x(1)/(12*x(2));
        case 10,
        out=1-(1.5*x(6)+1.9)/x(4);
        case 11,
        out=1-(1.1*x(7)+1.9)/x(5);
        otherwise,
            disp 'Unknown constraint requested';
    end
    error=0;
else
    disp 'No grad info available';
    error=1;
end



