function d = addpoint(d,varargin)
%ADDPOINT Add a point to the dataset
%    
%    ADDPOINT(D,VARARGIN) is equivalent to
%    [d;dataset(varargin)] and adds a point to the dataset.
%    
%    See also: ALSO VERTCAT, JOIN
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Add a point to the dataset
%
%   @synopsis	addpoint(d,varargin)
%   @description  is equivalent to [d;dataset(varargin)] and adds a point to the dataset.
%
%   @see also vertcat, join
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 19/03/99

%

if isempty(d.data),
	d = dataset(varargin{:});
else	
	d = vertcat(d,dataset(varargin{:}));
end	
