function d=classgroup(d,classes,groupclasses)
%CLASSGROUP Groups a few classes into more general classes
%    
%    OUT=CLASSGROUP(D,CLASSES,GROUPCLASSES) groups the groups
%    of classes specified by the cell array CLASSES into new
%    classes specified by the cell array GROUPCLASSES.
%    
%    See also: ALSO CLASSPART
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Groups a few classes into more general classes
%
%   @synopsis	out=classgroup(d,classes,groupclasses)
%   @description  groups the groups of classes specified by the cell array
%	<code>classes</code> into new classes specified by the cell array <code>groupclasses</code>.
%
%	@example
%	out=classgroup(d,{{'orange','lemon'},{'apple','pear'}},{'agrume','other'})
%	
%
%   @see also classpart
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 19/03/99

loadfromdisk(d)

select=[];
classcol = find(strcmp(d.vartypes,'class'));

sumlengths = 0;

for i=1:length(groupclasses),
	sumlengths = sumlengths + length(classes{i});
end

newnumbs = -(length(d.symbols{classcol}) - sumlengths + (1:length(groupclasses)));
originals = 1:length(d.symbols{classcol});
finals = 1:length(d.symbols{classcol}) - sumlengths;
removedlist = [];

for i=1:length(groupclasses),
	
	select=[];
	
	for j=1:length(classes{i}),
		ref = find(strcmp(d.symbols{classcol},classes{i}{j}));
		select=[select;find(d.data(:,classcol) == ref)];
		removedlist = [removedlist ref];
	end
	
	[d.data(select,classcol)] = newnumbs(i);
end

originals(removedlist) = [];
for i=1:length(originals),
	d.data(find(d.data(:,classcol) == originals(i)),classcol) = finals(i);
end

d.data = abs(d.data);
d.symbols{classcol}(removedlist) = [];
d.symbols{classcol} = [d.symbols{classcol} groupclasses];
