function d = normalise(d)
%NORMALISE performs a denormalisation of the continuous
%    data field of a dataset
%    
%    D = DENORMALISE(D)   denormalises the dataset D.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose performs a denormalisation of the continuous data field of a dataset.   
%
%   @synopsis d = denormalise(d)  
%   @description  denormalises the dataset <CODE>d</CODE>.
%
%MAN_PAGE_END

%By Patrice Latinne
%Written : 23/03/99


if isfield(d.opt,'mini')&isfield(d.opt,'denom')
	data = get(d,'contdata');
	mini = d.opt.mini;
	denom = d.opt.denom;
	ndata = data.*denom(ones(size(data,1),1),:)+mini(ones(size(data,1),1),:);

	d.opt = rmfield(d.opt,'mini');
	d.opt = rmfield(d.opt,'denom');
	set(d,'contdata',ndata);
else
	error('The data set is not normalised');
end

