function z = horzcat(varargin)
%HORZCAT Horizontal concatenation operator
%    
%    Z = HORZCAT(D1, D2, ...) Concatenates two or more data
%    sets D1, D2 horizontally. redundant classes are converted
%    to symbolic variables.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Horizontal concatenation operator
%
%   @synopsis	z = horzcat(d1, d2, ...)
%   @description  Concatenates two or more data sets <CODE>d1</CODE>, <CODE>d2</CODE>
%	horizontally. redundant classes are converted to symbolic variables.
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 19/03/99

z = varargin{1};
loadfromdisk(z);

for i=2:nargin,
	newdata = get_data(varargin{i});
	
	if ~isempty(newdata),
		if any(strcmp(z.vartypes,'class')),
			noclass = find(~strcmp(varargin{i}.vartypes,'class'));
		else
			noclass = 1:size(varargin{i}.vartypes,2);
		end
		
		z.variables = [z.variables varargin{i}.variables(:,noclass)];
		z.vartypes = [z.vartypes varargin{i}.vartypes(:,noclass)];
		z.symbols = [z.symbols varargin{i}.symbols(:,noclass)];
		
		if isempty(z.labels) | all(z.labels == [1:z.ns]'),
			z.labels = varargin{i}.labels;
		end
		
		z.data =[z.data newdata(:,noclass)];
	end
end

z = synccache(z);
