function [d,t] = normstd(d,t)
%NORMSTD NORMSTD performs a normalisation of the
%    continuous features of a learning set and a testing set
%    
%    The normalisation transforms the data so that their mean
%    is zero and standard deviation 1. 
%    
%    LEARNSET  = NORMSTD(LEARNSET); [LEARNSET, TESTSET] =
%    NORMSTD(LEARNSET, TESTSET); See also: NORMALISE
%    
%    

%MAN_PAGE_BEGIN 
%@purpose NORMSTD performs a normalisation of the continuous features of a learning set and a testing set. 
% The normalisation transforms the data so that their mean is zero and standard deviation 1. 
%@synopsis LEARNSET  = NORMSTD(LEARNSET);
% [LEARNSET, TESTSET] = NORMSTD(LEARNSET, TESTSET);
%
%@see normalise
%MAN_PAGE_END

% Copyright (c) 7/08/99
% $ Revision: 1.0 $ Patrice Latinne

datad = get(d,'contdata')';
meanp = mean(datad')';
stdp = std(datad')';
[R,Q]= size(datad);
oneQ = ones(1,Q);

equal = stdp==0;
nequal = ~equal;
if sum(equal) ~= 0
   warning('Some standard deviations are zero. Those inputs won''t be transformed.');
   meanp0 = meanp.*nequal + 0*equal;
   stdp0 = stdp.*nequal + 1*equal;
else
   meanp0 = meanp;
   stdp0 = stdp;  
end

learn = (datad-meanp0*oneQ)./(stdp0*oneQ);
set(d,'contdata',learn');
if nargin==2
   datat= get(t,'contdata')';
   oneQ= ones(1,size(datat,2));
   test = (datat-meanp0*oneQ)./(stdp0*oneQ);
   set(t,'contdata',test');
end
