function h=plot(d,colors,classes,feats)
%PLOT plot a dataset
%    
%    H=PLOT(D,COLORS) plot the dataset D using the cell array
%    of colors COLORS. Every classes are plot among the two
%    first variables. The handles of the plots for the
%    different classes are returned inside h.
%    
%    H=PLOT(D,COLORS,CLASSES) Only the classes specified
%    inside the cell array CLASSES are plot with respect to
%    the two first features.
%    
%    H=PLOT(D,COLORS,CLASSES,VARS) The classes specified
%    inside the cell array CLASSES are plot with respect to
%    the variables specified inside the array VARS.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	plot a dataset
%
%   @synopsis	h=plot(d,colors)
%   @description  plot the dataset <code>d</code> using
%	the cell array of colors <code>colors</code>. Every classes
%	are plot among the two first variables. The handles of the plots
%	for the different classes are returned inside h.
%
%   @synopsis	h=plot(d,colors,classes)
%   @description  Only the classes specified inside the cell array
%	<code>classes</code> are plot with respect to the two first features.
%
%   @synopsis	h=plot(d,colors,classes,vars)
%   @description  The classes specified inside the cell array
%	<code>classes</code> are plot with respect to the variables specified
%	inside the array <code>vars</code>.
%
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 18/03/99

if nargin<2,
	colors = {'r+','g+','b+','y+','m+','k+','c+','r*','g*','b*','y*','m*','k*','c*',...
		'rx','gx','bx','yx','mx','kx','cx','ro','go','bo','yo','mo','ko','co',...
		'rs','gs','bs','ys','ms','ks','cs','rd','gd','bd','yd','md','kd','cd',...
		'rp','gp','bp','yp','mp','kp','cp','rh','gh','bh','yh','mh','kh','ch'};
end

classeslist = get(d,'classeslist');

if nargin<3, classes = classeslist; end
if nargin<4, feats = [1 2]; end

h=[];
for i = 1:length(classes),
	cl = find(strcmp(classeslist,classes{i}));
	sub = classPart(d,classes(i));
	h(i)=plot(sub.data(:,feats(1)),sub.data(:,feats(2)),colors{mod(cl-1,56)+1});
	hold on
end
hold off
