function out = get_data(m,rows,cols)
%MAN_PAGE_BEGIN
%
%   @purpose	Common interface for accessing data of the object
%
%   @synopsis	out = get_data(m,rows,cols)
%   @description  transparently get data from memory or from the disk. In the
%	latter case, cache data inside the object structure.
%
%   @see 
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 31/05/99

% Needs to be modified in order to load only necessary pieces of data

if isempty(m.data) & ~isempty(m.filename) & ~strcmp(m.filename,'nofile'),
	f = load(m.filename);
	for i=1:length(m.variables),
		m.data = [m.data getfield(f,m.variables{i})];
	end
end

if isempty(m.data),
	out =[];
	return
end

if nargin == 3,
	if ischar(rows) & strcmp(rows,':'),
		out = m.data(:,cols);
	end
	out = m.data(rows,cols);
elseif nargin == 2,
	out = m.data(rows,:);
else
	out = m.data;
end

%Now try to save the cached data
try,
	assignin('caller',inputname(1),m);
catch
end
