function m = lazy(varargin)
%LAZY Constructor for the lazy abstract class
%    
%    This class implements the famimo class and allows to
%    describe dynamical systems using a 'lazy' representation.
%    It works in a very simple way. The input-output data is
%    stored in a database. When a prediction of the putput is
%    needed a local model  is fitted through the closest
%    points of the query contained in  the database.
%    The elements that describe the lazy model associated with
%    each output are  defined by the following attributes:
%    
%      ID_PAR: identification parameters
%      CMB_PAR: model combination parameters
%    
%    M=LAZY creates a new general lazy skeleton
%    
%    M=LAZY(NAME,N_IN,N_OUT) creates a new general lazy with
%    N_IN inputs and N_OUT outputs. The name NAME is
%    associated to it.
%    
%    The class defines the following methods:
%    
%      CHECK: checks the consistency of all the field of a
%          lazy object
%      DENORMALISE: denormalises the model M
%      DISPLAY: Display an object of class lazy
%      EVAL: computes the value of the lazy for some input
%      GET: gets the value of the attribute of an object
%      IDENTIFY: Identify the lazy model from data
%      JACOB_INPUTS: computes the jacobian of the model
%      JACOB_PARAMS: computes the jacobian of the model
%      NORMALISE: normalises the model M
%      SET: Set object properties
%    
%    See also: MAPPING
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Constructor for the lazy abstract class.
%   This class implements the famimo class and allows to describe
%   dynamical systems using a 'lazy' representation.
%   It works in a very simple way. The input-output data is stored in
%   a database. When a prediction of the putput is needed a local model 
%   is fitted through the closest points of the query contained in 
%   the database.<br>
%   The elements that describe the lazy model associated with each output are 
%   defined by the following attributes:
%<dl>
%<dt>    id_par <dd> identification parameters   
%<dt>    cmb_par <dd> model combination parameters
%</dl>
%
%   @synopsis	m=lazy
%   @description  creates a new general lazy skeleton
%
%   @synopsis	m=lazy(name,n_in,n_out)
%   @description  creates a new general lazy with <CODE>n_in</CODE> inputs
%	and <CODE>n_out</CODE> outputs. The name <CODE>name</CODE> is associated to it.
%	
%   @see mapping
%
%MAN_PAGE_END

error(checkargs(varargin,[0 3],'any','numeric','numeric'));

m=[];
if nargin == 0,         %if no arguments build an empty object
  m.id_par= [];
  m.cmb_par = 1;
  m.examples_x=[];
  m.examples_y=[];
  
  f=mapping;  
  m=class(m,'lazy',f);
  
elseif nargin==1,              %if one argument
  if isa(varargin{1},'lazy') & isa(varargin{1}.mapping ,'mapping'),   %if type lazy clone it
    m=varargin{1};
  elseif isa(varargin{1},'mapping') & ~ isa(varargin{1},'lazy'), %if type mapping add the fields
    m.id_par= [];
    m.cmb_par = 1;
    m.examples_x=[];
    m.examples_y=[];  	
    
    f=varargin{1};
    m=class(m,'lazy',f);   
    
  else  %if it is something else (usually for update purposes)
    
    m.id_par= [];
    m.cmb_par = 1;
    m.examples_x=[];
    m.examples_y=[];        
    
    f=mapping;
    arg = struct(varargin{1});
    
    if isfield(arg,'mapping'),
      f = mapping(arg.mapping);
      arg = rmfield(arg,'mapping');
      
      fn=fieldnames(m);
      for i=1:size(fn,1),
	if isfield(arg,fn{i}),
	  m=setfield(m,fn{i},getfield(arg,fn{i}));
	end
      end  
    end
    
    m=class(m,'lazy',f);
  end
elseif nargin>1,
  m.id_par= [];
  m.cmb_par = 1;
  m.examples_x=[];
  m.examples_y=[];
  
  f=mapping(varargin{:});
  m=class(m,'lazy',f);
end    




