function m = linear(varargin)
%LINEAR Constructor for the linear class
%    
%    M=LINEAR creates a new linear skeleton
%    
%    M=LINEAR(NAME,N_IN,N_OUT) creates a new linear	mapping
%    with N_IN inputs and N_OUT outputs. The name NAME is
%    associated to it.
%    
%    The class defines the following methods:
%    
%      CHECK: checks the consistency of all the field of a
%          linear object
%      DENORMALISE: denormalises the model M
%      DISPLAY: Display an object of class linear
%      DOUBLE: Convert the object to double
%      EVAL: computes the value of the linear for some input
%      GET: gets the value of the attribute of an object
%      IDENTIFY: Identify the mapping from data
%      JACOB_INPUTS: computes the jacobian of the model
%      JACOB_PARAMS: computes the jacobian of the model
%      NORMALISE: normalises the model M
%      SET: Set object properties
%    
%    See also: MAPPING
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Constructor for the linear class
%
%   @synopsis	m=linear
%   @description  creates a new linear skeleton
%
%   @synopsis	m=linear(name,n_in,n_out)
%   @description  creates a new linear  mapping with <CODE>n_in</CODE> inputs
%	and <CODE>n_out</CODE> outputs. The name <CODE>name</CODE> is associated to it.
%	
%
%   @see mapping
%
%MAN_PAGE_END

error(checkargs(varargin,[0 3],'any','numeric','numeric'));

m=[];
if nargin==0                   %if no arguments build an emty object
	m.linears = [];
  	
  	f=mapping;
  	m=class(m,'linear',f);
  	
elseif nargin==1,              %if one argument
	if isa(varargin{1},'linear') & isa(varargin{1}.mapping ,'mapping'),   %if type taksug clone it
	    m=varargin{1};
	elseif isa(varargin{1},'mapping') & ~ isa(varargin{1},'linear'), %if type mapping add the fields
	    m.linears = [];
  		
  	    f=varargin{1};
        m=class(m,'linear',f);
	else                              %if it is something else (usually for update purposes)
	    m.linears = [];
  		
  		f=mapping;
	  	
	 	arg = struct(varargin{1});
	  	
	  	if isfield(arg,'mapping'),
	    f = mapping(arg.mapping);
	    arg = rmfield(arg,'mapping');
	    
	    fn=fieldnames(m);
	    for i=1:size(fn,1),
	      if isfield(arg,fn{i}),
		  	m=setfield(m,fn{i},getfield(arg,fn{i}));
	      end
	    end  
	  end
	  
	  m=class(m,'linear',f);
	end
elseif nargin>1,
  m.linears = [];
  	
  f=mapping(varargin{:});
  	
  m=class(m,'linear',f);
  
  m.linears = zeros(get(m,'n_out'),get(m,'n_in') + 1);
  set(m,'optimparams',1:(get(m,'n_out') * (get(m,'n_in') + 1)));
end



