function check(m); 
%CHECK checks the consistency of all the field of a
%    mamdani object
%    
%    This function has been provided in order to make the
%    mamdani class more robust since it checks a mamdani
%    object for consistency of the data defined in its fields.
%    If a inconsistency is found, an  error message is
%    displayed.
%    
%    CHECK(M) check the consistency of a mamdani object.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose checks the consistency of all the field of a mamdani object.
%   This function has been provided in order to make the mamdani class
%   more robust since it checks a mamdani object for consistency of
%   the data defined in its fields. If a inconsistency is found, an 
%   error message is displayed.
%
%   @synopsis check(m)
%   @description  check the consistency of a mamdani object.
%
%MAN_PAGE_END

error(checkargs({m},1,'mamdani'));

%Check the fields of the mapping superclass
check(m.mapping);

sm = struct(m);

                %first check for all the required fields
if ~isfield(sm,'n_rules'),
   		error('object MAMDANI should have a ''n_rules'' field');
end
if ~isfield(sm,'model_code'),
   		error('object MAMDANI should have a ''model_code'' field');
end

if m.n_rules == 0,
	if ~isempty(m.rls),
		error(['''rls'' field is not the right size']);
	end
else
	if size(m.rls) ~= [m.n_rules get(m,'n_in')+get(m,'n_out')],
		error(['''rls'' field is not the right size']);
	end
end

if ~isempty(m.rls),
	for i=1:get(m,'n_in')+get(m,'n_out'),
		if size(m.mfs{i},1)<max(m.rls(:,i)),
			error(['Missing fuzzy sets along dimension ' num2str(i) ' inside ''mfs''']);	
		end
	end
end
