function d=get(m,label);
%GET gets the value of the attribute of an object
%    
%    D = GET(M,LABEL) gets the value of the attribute LABEL
%    associated to the object M and return it inside D. The
%    following codes are recognised:
%    
%      NAME: returns the name of the object
%      N_IN: returns the number of inputs of the mapping
%      N_OUT: returns the number of outputs of the mapping
%      USERDATA: returns the 'userData' field
%      OPT: returns the 'opt' field
%      DATE: returns the date of creation of the object
%      LIMITS: returns the limits of the mapping
%      OPTIMPARAMS: returns the indices of the parameters to
%          be optimised
%      NUMPARAMS: returns the number of parameters to be
%          optimised
%      N_RULES: returns the number of rules associated to
%          the taksug model
%      MODEL_CODE: returns the code of the model associated
%          to the
%      RLS: returns the fuzzy sets associated to the taksug
%          model
%      MFS: returns the definition of the rules of the
%          taksug model
%      PARAMS: returns every parameters to be optimised in
%          the shape of a vector
%    
%    See also: SET
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  gets the value of the attribute of an object.
%
%   @synopsis	d = get(m,label)
%   @description gets the value of the attribute <code>label</code>
%   associated to the object <code>m</code> and return it inside <code>d</code>.
%	The following codes are recognised:
%<dl>
%<dt>		name  <dd>	returns the name of the object
%<dt>     n_in  <dd>      	returns the number of inputs of the mapping
%<dt>     n_out  <dd>     	returns the number of outputs of the mapping
%<dt>			userData <dd>		returns the 'userData' field
%<dt>			opt			 <dd>		returns the 'opt' field
%<dt>			date		 <dd>		returns the date of creation of the object
%<dt>	 limits	 <dd>				returns the limits of the mapping
%<dt>	 optimparams	 <dd>		returns the indices of the parameters to be optimised
%<dt>	 numparams	 <dd>		returns the number of parameters to be optimised
%<dt> n_rules      <dd>   returns the number of rules associated to the
%                         taksug model 
%<dt> model_code   <dd>   returns the code of the model associated to the
%<dt> rls  <dd>           returns the fuzzy sets associated to the taksug
%                         model
%<dt> mfs  <dd>       returns the definition of the rules of the taksug model
%<dt> params  <dd>       returns every parameters to be optimised in the shape of a vector
%</dl> 
%   @see set
%
%MAN_PAGE_END   


  switch label,

   case 'n_rules',
    d = m.n_rules; 
   case 'model_code',
    d= m.model_code;
   case 'rls',
    d= m.rls; 
   case 'mfs',
    d= m.mfs; 
   case 'ling',
    d= m.ling; 
   case 'varnames',
    d= m.varnames; 
  otherwise 
    d = get(m.mapping,label);
  end		
