function out=jacob_params(m,varargin)
%JACOB_PARAMS computes the jacobian of the model
%    
%    JACOB_PARAMS(M,X)   computes for each output the jacobian
%    of the model with respect to the parameters at input X.
%    
%    JACOB_PARAMS(M,X,J)   computes for output(s) J the
%    jacobian of the model with respect to the parameters at
%    input X.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  computes the jacobian of the model.
%
%   @synopsis jacob_params(m,x)  
%   @description computes for each output the jacobian of
%  the model with respect to the parameters at input <CODE>x</CODE>.
%
%   @synopsis jacob_params(m,x,j)  
%   @description computes for output(s) <CODE>j</CODE> the jacobian of
%  the model with respect to the parameters at input <CODE>x</CODE>.
%
%
%MAN_PAGE_END    

error(checkargs([{m} varargin],[2 3],'taksug','numeric','numeric'));

check(m);

if strcmpi(m.model_code{1},'projected'),
	error('This function only supports product space antecedents');
end

x = varargin{1};
if (nargin == 2)|isempty(varargin{2}),
	j = 1:get(m,'n_out');
else
	j = varargin{2};
end



if ~isempty(get(m,'optimparams')),
	out = out(:,get(m,'optimparams'));
end
