function m=normalise(m)
%NORMALISE normalises the model M
%    
%    M=NORMALISE(M) normalises the model M
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose normalises the model M.  
%
%   @synopsis   m=normalise(m)
%   @description normalises the model <CODE>m</CODE>
%
%MAN_PAGE_END  

check(m);

n_in = get(m,'n_in');
n_out = get(m,'n_out');

m.mapping = normalise(m.mapping);

opt = get(m,'opt');
limits = opt.original_limits;

theMinIn = limits(1,1:n_in)';
theMinOut = limits(1,n_in+1:n_in+n_out)';
theMaxIn = limits(2,1:n_in)';
theMaxOut = limits(2,n_in+1:n_in+n_out)';

N=diag(theMaxIn-theMinIn);

f2 = theMaxOut - theMinOut;
f3 = theMaxIn - theMinIn;

for i = 1:n_in,
	m.mfs{i}(:,2:end) = (m.mfs{i}(:,2:end) - theMinIn(1,i)) / f3(1,i);
end

for i = 1:n_out,
	m.mfs{n_in+i}(:,2:end) = (m.mfs{n_in+i}(:,2:end) - theMinOut(1,i)) / f4(1,i);
end
