function out=eval(m,varargin)
%EVAL computes the value of the linear for some input
%    
%    OUT=EVAL(M,REGRESSOR,J) returns the value OUT of the
%    output(s) J of linear M given the input(s) X.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  computes the value of the linear for some input.
%   
%   @synopsis out=eval(m,regressor,j)
%   @description  returns the value <code>out</code> of the output(s) <code>j</code> of
%   linear <code>m</code> given the input(s) <code>x</code>.
%
%MAN_PAGE_END

error(checkargs([{m} varargin],[2 3],'series','numeric','numeric'));

x = varargin{1};
if (nargin == 2)|isempty(varargin{2}),
	j = 1:get(m,'n_out');
else
	j = varargin{2};
end

e1 = eval(m.mapping1,x(:,m.links.Sm1));
um2 = [x(:,m.links.Sm2) e1(:,m.links.Sm21)];
if isfield(m.links,'perm1'),
	um2 = um2(:,m.links.perm1);
end
e2 = eval(m.mapping2,um2);

out = [x(:,m.links.Sy1) e1(:,m.links.Sy2) e2(:,m.links.Sy3)];
if isfield(m.links,'perm2'),
	out = out(:,m.links.perm2);
end

out = out(:,j);
