function out=eval(m,varargin)
%EVAL computes the value of the system for some regressor
%    
%    OUT=EVAL(M,R,J) returns the value OUT of the output(s) J
%    of mapping M given the input regressor R.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  computes the value of the system for some regressor.
%   
%   @synopsis out=eval(m,r,j)
%   @description  returns the value <code>out</code> of the output(s) <code>j</code> of
%   mapping <code>m</code> given the input regressor <code>r</code>.
%
%MAN_PAGE_END
  

%error(checkargs([{m} varargin],[2 3],'system',{'numeric' 'cell'},'numeric'));

r = varargin{1};
if (nargin == 2)|isempty(varargin{2}),
	j = 1:get(m,'n_out');
else
	j = varargin{2};
end

if ~iscell(r),
	sr = r;
	r = {};
	for ii=1:length(j),
		r{ii} = sr;
	end
end

listlinks = m.links(j,:);
out=zeros(size(r{1},1),length(j));

k=0;
for i = unique(listlinks(:,1))',
	k=k+1;
	outs = find(listlinks(:,1) == i);
	out(:,outs) = eval(m.mapping{i},r{k},listlinks(outs,2));
end

%saturate the output
limits=get(m,'limits');
out_limit=limits(:,get(m,'n_in')+1:end);
for i=1:size(j,1),
  if out(i,1)<out_limit(1,j(i)),
    out(i,1)=out_limit(1,j(i));
  elseif  out(i,1)>out_limit(2,j(i)), 
    out(i,1)=out_limit(2,j(i));
  end
end  
