function out=jacob_params(m,r,j)
%JACOB_PARAMS computes the jacobian of the model
%    
%    JACOB_PARAMS(M,R)   computes for each output the jacobian
%    of the model with respect to the parameters at regressor
%    R.
%    
%    JACOB_PARAMS(M,R,J)   computes for output(s) J the
%    jacobian of the model with respect to the parameters at
%    regressor REGRESSOR.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose  computes the jacobian of the model.
%
%   @synopsis jacob_params(m,r)  
%   @description computes for each output the jacobian of
%  the model with respect to the parameters at regressor <CODE>r</CODE>.
%
%   @synopsis jacob_params(m,r,j)  
%   @description computes for output(s) <CODE>j</CODE> the jacobian of
%  the model with respect to the parameters at regressor <CODE>regressor</CODE>.
%
%
%MAN_PAGE_END    


%   Copyright (c) 1998 by Antoine Duchateau			
%	$Revision: 0.1$  $Date: 10/12/1997
%
%	All rights reserved
%keyboard
  
if nargin == 2,
	j = 1:get(m,'n_out');
end

error(checkargs([{m r j}],[2 3],'system','cell','numeric'));

check(m);

out = [];

sublinks = m.links(j,:);

uni = unique(sublinks(:,1))';

np = zeros(length(m.mapping),1);
for i=uni,
	np(i) = get(m.mapping{i},'numparams');
end

out = zeros(size(j,1),sum(np));
offset = 0;

for i=uni,
	outs = find(sublinks(:,1) == i);
	for j=1:size(outs,1),
	  out(outs(j),offset+(1:np(i))) = jacob_params(m.mapping{i},r{outs(j)},sublinks(outs(j),2));
	end
	offset = offset + np(i);
end





