function m = add_sets(m,i,n,t)
%ADD_SETS Add fuzzy sets along one or more dimensions of
%    the input space
%    
%    M = ADD_SETS(M,I,N,T) adds N sets to the dimension I of
%    the Takagi Sugeno Function M. The sets are of type t
%    Accepted values for T are 'constant,
%    'trapezoidal','gaussian' and 's-shaped'. This method is
%    used to define the fuzzy sets for the 'projected' type of
%    fuzzy model.
%    
%    See also: ADD_RULES
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Add fuzzy sets along one or more dimensions of the input space
%
%   @synopsis	m = add_sets(m,i,n,t)
%   @description  adds <CODE>n</CODE> sets to the dimension <CODE>i</CODE>
%	of the Takagi Sugeno Function <CODE>m</CODE>. The sets are of type t
%	Accepted values for <CODE>t</CODE> are 'constant, 'trapezoidal','gaussian'
%	and 's-shaped'. This method is used to define the fuzzy sets for the 'projected'
%	type of fuzzy model.
%
%   @see add_rules
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 19/05/99

if nargin<4,
	t = 'trapezoidal';
end

error(checkargs({m i n t},4,'taksug','numeric','numeric','char'));

switch lower(t),
case 'constant',
code = 0;

case 'trapezoidal',
code = 1;

case 'gaussian',
code = 2;

case 's-shaped',
code = 3;

otherwise
error('Unrecognized rule type');
end

m.mfs{i} = [m.mfs{i}; repmat([code 0 0 0 0],[n 1])];

if nargout == 0,
	assignin('caller',inputname(1),m)
end
