function check(m); 
%CHECK checks the consistency of all the field of a taksug
%    object
%    
%    This function has been provided in order to make the
%    taksug class more robust since it checks a taksug object
%    for consistency of the data defined in its fields. If a
%    inconsistency is found, an  error message is displayed.
%    
%    CHECK(M) check the consistency of a taksug object.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose checks the consistency of all the field of a taksug object.
%   This function has been provided in order to make the taksug class
%   more robust since it checks a taksug object for consistency of
%   the data defined in its fields. If a inconsistency is found, an 
%   error message is displayed.
%
%   @synopsis check(m)
%   @description  check the consistency of a taksug object.
%
%MAN_PAGE_END

error(checkargs({m},1,'taksug'));

%Check the fields of the mapping superclass
check(m.mapping);

sm = struct(m);

                %first check for all the required fields
if ~isfield(sm,'n_rules'),
   		error('object TAKSUG should have a ''n_rules'' field');
end
if ~isfield(sm,'model_code'),
   		error('object TAKSUG should have a ''model_code'' field');
end
if ~isfield(sm,'m'),
   	error('object TAKSUG should have a ''m'' field for defining the fuzzyness');
end  
if ~isfield(sm,'centers'),
   		error('object TAKSUG should have a ''centers'' field');
end
if ~isfield(sm,'ivariances'),
   		error('object TAKSUG should have a ''ivariances'' field');
end	
if ~isfield(sm,'linears'),
   		error('object TAKSUG should have a ''linears'' field');
end

if ~isempty(m.model_code),
  if strcmp(m.model_code{1},'productspace'),
    if m.n_rules == 0,
      if ~isempty(m.centers),
	error(['''centers'' field is not the right size']);
      end
    else
      if any(size(m.centers) ~= [get(m,'n_in') m.n_rules]),
	error(['''centers'' field is not the right size']);
      end
    end
    
    if m.n_rules == 0,
      if ~isempty(m.ivariances),
	error(['''ivariances'' field is not the right size']);
      end
    elseif m.n_rules == 1,
      if size(m.ivariances) ~= [get(m,'n_in') get(m,'n_in')],
	error(['''ivariances'' field is not the right size']);
      end
    elseif size(m.ivariances) ~= [get(m,'n_in') get(m,'n_in') m.n_rules],
      error(['''ivariances'' field is not the right size']);
    end
  elseif strcmp(m.model_code{1},'projected'),
    if m.n_rules == 0,
      if ~isempty(m.rls),
	error(['''centers'' field is not the right size']);
      end
    else
      if size(m.rls) ~= [m.n_rules get(m,'n_in')],
	error(['''rls'' field is not the right size']);
      end
    end
    if ~isempty(m.rls),
      for i=1:get(m,'n_in'),
	if size(m.mfs{i},1)<max(m.rls(:,i)),
	  error(['Missing fuzzy sets along dimension ' num2str(i) ' inside ''mfs''']);	
	end
      end
    end
  end
end

  
if m.n_rules == 0,
	if ~isempty(m.linears),
		error(['''linears'' field is not the right size']);
	end
elseif m.n_rules == 1,
	if size(m.linears) ~= [get(m,'n_out') get(m,'n_in')+1],
		error(['''linears'' field is not the right size']);
	end
elseif size(m.linears) ~= [get(m,'n_out') get(m,'n_in')+1 m.n_rules],
	error(['''linears'' field is not the right size']);
end	

