function drawcontrols(m,f,a,bounds)
%DRAWCONTROLS Draw controls which allow to control the
%    plot behaviour
%    
%    DRAWCONTROLS(M,F,A,BOUNDS) binds a series of controls
%    drawed inside BOUNDS, to the figure F and the axes A.
%    
%    See also: PLOT
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Draw controls which allow to control the plot behaviour.
%
%   @synopsis	drawcontrols(m,f,a,bounds)
%   @description  binds a series of controls drawed inside <CODE>bounds</CODE>,
%	to the figure <CODE>f</CODE> and the axes <CODE>a</CODE>.
%
%   @see plot
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 7/06/99

f = gcf;

ud = get(f,'userdata');

if isfield(ud,'controls'),
	fn = fieldnames(ud.controls),
	for i=1:length(fn),
		delete(getfield(ud.controls,fn{i}));
	end
end

ud.controls = [];

ud.controls.objs = uicontrol('style','listbox',...
					'units','normal',...
					'min',0,...
					'max',6,...
					'value',1:6, ...
					'string',{	'Mapping value';'Membership functions';...
								'Clusters';'Consequents';'Error function';'Data'}, ...
					'BackgroundColor',[1 1 1], ...
					'Userdata', a, ...
					'Callback', 'TSctrlsCB;', ...
					'position',[[0 0.6].*bounds(3:4)+bounds(1:2) [1 0.4].*bounds(3:4)]);
					

pops = {};
for i=1:get(m,'n_in'),
	pops{i} = ['input ' num2str(i)];
end
pops = [pops';{'none'}];


ud.controls.i1 = uicontrol('style','popupmenu',...
					'units','normal',...
					'BackgroundColor',[1 1 1], ...
					'string',pops, ...
					'Userdata', a, ...
					'Callback', 'TSctrlsCB;', ...
					'position',[[0 0.45].*bounds(3:4)+bounds(1:2) [1 0.11].*bounds(3:4)]);
					
ud.controls.i2 = uicontrol('style','popupmenu',...
					'units','normal',...
					'BackgroundColor',[1 1 1], ...
					'string',pops, ...
					'Userdata', a, ...
					'Callback', 'TSctrlsCB;', ...
					'Value', 2, ...
					'position',[[0 0.33].*bounds(3:4)+bounds(1:2) [1 0.11].*bounds(3:4)]);
					
if get(m,'n_in') <= 1,
	set(ud.controls.i2,'visible','off','enable','off','value',get(m,'n_in')+1);
end
					
pops = {};
for i=1:get(m,'n_out'),
	pops{i} = ['output ' num2str(i)];
end

pops = pops';

ud.controls.out = uicontrol('style','popupmenu',...
					'units','normal',...
					'BackgroundColor',[1 1 1], ...
					'string',pops, ...
					'Userdata', a, ...
					'Callback',  'TSctrlsCB;', ...
					'position',[[0 0.21].*bounds(3:4)+bounds(1:2) [1 0.11].*bounds(3:4)]);
					
ud.controls.axis = uicontrol('style','edit',...
					'units','normal',...
					'BackgroundColor',[1 1 1], ...
					'Userdata', a, ...
					'Callback',  'TSctrlsCB;', ...
					'position',[[0 0.0].*bounds(3:4)+bounds(1:2) [1 0.2].*bounds(3:4)]);
					
set(f,'userdata',ud);


