function l=interp_model(m,x,j)
%INTERP_MODEL Computes a local fuzzy combination of the
%    consequents of the rules
%    
%    L=INTERP_MODEL(M,X,J) computes for TAKSUG model M, a
%    fuzzy combination of the consequents of the rules at
%    point X. L is equal to a linear combination of the
%    parameters of the consequents for each rule. The
%    coefficient  of the linar combination are equal to the
%    membership of X to the different rules.
%    
%    See also: ALSO JACOB_PARAMS 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Computes a local fuzzy combination of the consequents of the rules
%
%   @synopsis	l=interp_model(m,x,j)
%   @description  computes for <code>taksug</code> model <code>m</code>, a fuzzy combination
%	of the consequents of the rules at point <code>x</code>. <code>l</code> is equal to
%	a linear combination of the parameters of the consequents for each rule. The coefficient 
%	of the linar combination are equal to the membership of <code>x</code> to the different rules.
%	
%   @see also jacob_params 
%
%MAN_PAGE_END


mb = reshape(membership(m,x),[1 1 m.n_rules]);

if strcmpi(m.model_code{2},'ungaussian')|strcmpi(m.model_code{2},'uninversedist'),
	l = sum(m.linears(j,1:end-1,:).*repmat(mb,[1 size(m.linears,2)-1 1]),3);
else
	l = sum(m.linears(j,1:end-1,:).*repmat(mb,[1 size(m.linears,2)-1 1]),3)/(sum(mb)+realmin);
end
