function [S1,S2,S3]=coneval(Centre,P1,P2,P3,P4,P5,P6)

%CONEVAL
%
%	CONEVAL EVALuates the CONicity criterium.
%	CONEVAL(CENTRE,A,B,C,D,INPUTS,OUTPUTS) returns the conicity index:
%		CONICITY INDEX = CONIC DESVIATION / CONIC ROBUSTNESS
%
%	CONIC DESVIATION of the nonlinear controller for centre (CENTRE) is:
%		CONIC DESVIATION = GAIN{CONTROLLER - CENTRE)
%	this is also called Nonlinear Conicity Radius.
%
%	CONIC ROBUSTNESS of the linear plant (A,B,C,D) with hkfeedback CENTRE is:
%		CONIC ROBUSTNESS = 1 / GAIN{FEEDB((A,B,C,D),CENTRE)
%	this is also called Linear Conicity Radius.
%
%	[ConRob,ConDes]=CONEVAL(CENTRE,A,B,C,D,INPUTS,OUTPUTS) returns Conic
%	Robustness and Conic Desviation.
%
%	[ConInd,ConRob,ConDes]=CONEVAL(CENTRE,A,B,C,D,INPUTS,OUTPUTS)  returns Conic
%	Robustness, Conic Desviation and Conicity Index.
%
%	CONEVAL(CENTRE,INPUTS,OUTPUTS)  returns Conic Desviation.
%
%	CONEVAL(CENTRE,A,B,C,D)  returns Conic Robustness.
%
%	See also X_CONLTI y X_CONNLS

%-----------------------------------------------
%  Departamento de Sistemas y Automatica
%  Universidad de Sevilla
%-----------------------------------------------
%  File: coneval.m
%  Project:  FAMIMO
%  Block:  conicity
%  Use:  Master Function
%-----------------------------------------------
%  Toolbox used:  
%  Other functions used:  x_conlti.m and x_connls.m
%-----------------------------------------------
%  Authors:  Javier Martin Recio  
%  E-mail:  jmartin@cartuja.us.es
%  Date:  JUN/30th/97
%-----------------------------------------------
%  Last update
%   Date:  SEP/25th/97
%   Name:  Javier Martin Recio
%   Main changes: Outputs order has been altered.
%
%   Version:  1.1
%-----------------------------------------------
%  System:  MATLAB 4.2b or higher
%-----------------------------------------------
%  If you have any question please contact us: 
%  E-mail ...
%-----------------------------------------------

%-----------------------------------------------
%  Main variables descripcion:
%
%	nlsGain: Gain{Controller-Centre}. Conic Desviation.
%	ltiGain: Gain{Feedb(Plant,Centre)}. Inverse of Conic Robustness.
%
%-----------------------------------------------

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Checking input arguments and obtaining Radius %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

error(nargchk(3,7,nargin));

nlsGain=[];
ltiGain=[];

if nargin>4,			% Selecting depend on number of arguments

  ltiGain=x_conlti(P1,P2,P3,P4,Centre);		% Inverse of Conic Robustness

  if nargin==7,
    nlsGain=x_connls(P5,P6,Centre);		% Conic Desviation
  end;

else

  nlsGain=x_connls(P1,P2,Centre);		% Conic Desviation

end;

%%%%%%%%%%%%%%%%%%%%%
% Outputs selection %
%%%%%%%%%%%%%%%%%%%%%

if nargout==2,		% Selects the output values depending on number of output arguments
  S1=1/ltiGain;	
  S2=nlsGain;
elseif nargout==3,
  S1=nlsGain*ltiGain;		% Conicity Index
  S2=1/ltiGain;
  S3=nlsGain;
else
  if nargin==7,
    S1=nlsGain*ltiGain;
  elseif nargin<5,
    S1=nlsGain;
  else
    S1=1/ltiGain;
  end;
end;

%%%%%%%%%%%%%%%%%%%%%%%%
% End of this function %
%%%%%%%%%%%%%%%%%%%%%%%%