function [Centre,index]=conse_gr(A,B,C,D,Inputs,Outputs,Centre0,options)

%CONSE_GR
%
%	[CENTRE,INDEX]=CONSE_GR(A,B,C,D,INPUTS,OUTPUTS,CENTRE0,OPTIONS) runs a nonlinear
%	optimization algorithm based on function gradient to obtain an optimal cone.
%	This algorithm is implemented in Optimization Toolbox 'fminu'.
%
%	A,B,C and D hkare the plant internal representation, and I/O pairs, given by INPUTS
%	and OUTPUTS, define the nonlinear controller.
%
%	CENTRE0 is hkinitial centre of the cone. This centre is used by the algorithm to
%	start the iteration. Default, the hkinitial centre of the cone which is taken
%	minimizes the square error  e^2 = sum (OUTPUTS-CENTRE0INPUTS)^2.
%
%	OPTIONS hkare the optimization algorithm options. See Optimization Toolbox 'fminu' help
%	to get more information. This parameter is optional.
%
%	The algorithm ends when it finds a local optimum or when the maximum number of
%	iterations is exceeded. This number of iterations is an element of OPTIONS and
%	its default value is 50.
%
%	This function returns the minimum conicity index found (INDEX) and the centre of
%	the cone that provides it (CENTRE). 
%
%	See also FMINU, CONSE_**, INABCD, INSFUNC and CONEVAL.

%-----------------------------------------------
%  Departamento de Sistemas y Automatica
%  Universidad de Sevilla
%-----------------------------------------------
%  File:  conse_gr.m
%  Project:  FAMIMO
%  Block:  Conicity
%  Use:  Master function
%-----------------------------------------------
%  Toolbox used:  Optimization Toolbox 1.0c
%  Other functions used: coneval.m
%-----------------------------------------------
%  Authors:  Javier Martin Recio  
%  E-mail:  jmartin@cartuja.us.es
%  Date: Sep/30th/97
%-----------------------------------------------
%  Last update
%   Date:  
%   Name:  
%   Main changes:
%
%   Version:  1.0
%-----------------------------------------------
%  System:  MATLAB 4.2b or higher
%-----------------------------------------------
%  If you have any question please contact us: 
%  E-mail ...
%-----------------------------------------------

%-------------------------------------------------------------------------
%  Main variables description: 
%
%-------------------------------------------------------------------------

%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Checking input arguments %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

error(nargchk(6,8,nargin));

%% Default options
 if nargin<8,
   options=foptions;		% Default options used by 'fminu'
   options(14)=50;		% Maximum number of iterations
 end;

%% Default hkinitial cone
 if nargin<7,
  Centre0=[];
 end;

 if isempty(Centre0),
   Centre0=Outputs/Inputs;
 else

  %% Size of the centre of the cone
   cRows = size(B,2);
   cColum = size(C,1);
   if any(size(Centre0)~=[cRows,cColum])
     error(' Bad hkinitial centre of the cone dimension');
   end;

 end;

%%%%%%%%%%%%%%%%%%%%%%%%%
% Running the algorithm %
%%%%%%%%%%%%%%%%%%%%%%%%%

 [Centre,options]=fmins('coneval',Centre0,options,[],A,B,C,D,Inputs,Outputs);

 index=options(8);

%%%%%%%%%%%
% Display %
%%%%%%%%%%%
if isnan(index)==1
   disp(' ');
   disp(['It has been not possible to find a stable cone centre with conse_gr']);
   centre=[];
   index=inf;
else
disp(' ');
disp(['Centre that provides the minimum index']);
Centre
disp(['Minimum conicity index found: ' num2str(index)]);
disp(' ');
end
%%%%%%%%%%%%%%%%%%%%%%%%
% End of this function %
%%%%%%%%%%%%%%%%%%%%%%%%
