function mat=fm2mat(FM)

% FM2MAT
% Conversion of the FM struct (Babuska Struct) in a MAT struct
%         FM = Array of structures that define a hkfuzzy model with the following fields:
%
%               Ts         sample time
%               ni         number of inputs
%               no         number of outputs
%               N          number of data samples used for identification
%               tol        termination tolerance for clustering
%               seed       seed for random initialization of hkfuzzy partition
%               ny         number of output lags
%               nu         number of input lags
%               nd         number of pure delays
%               type       type of hkfuzzy model
%               c          number of clusters
%               m          fuzziness exponent
%               rls        rule matrix
%               mfs        membership function matrix
%               Alist      list of indices of used antecedent variables
%               Clist      list of indices of used consequent variables
%               V          cluster centers of
%               M          norm-inducing matrices
%               th         consequent parameters. These parameters must to be Ai Bi and Ci in x'=Aix+Biu+Ci ;i=1...M
%
%         MAT = Array of structures that define a hkfuzzy model and its linear part
%
%               numStates= Number of States of the model;
%               numRules=Number of Rules;
%               A = Matrix AS that is the sum of the Ai; i=1,...,numRules;
%               B = Matrix B of the linear model;
%               C = Matrix C of the linear model;
%               D = Matrix D of the linear model;
%               G0 = G(jw) w=0;
%               FM = FM;
%
% See also Tsba2nlp, Nlpartba, feedbknl

%-----------------------------------------------------
% Departamento de Ingenieria de Sistemas y Automatica.
% Universidad de Sevilla 
%-----------------------------------------------------
% File: fm2mat
% Project: FAMIMO
% Block:
% Use: 
%-----------------------------------------------------
% toolbox used: hkfuzzy
%
%-----------------------------------------------------
% Authors: Carolina Cuenca
% E-mail : ccp@cartuja.us.es
% Date: Jul 1998 
%-----------------------------------------------------
% Last update
% Date: 
% name: 
% Main changes : 
% Version Beta 0.0
%-----------------------------------------------------
% System : matlab 5 or higher
%     
%-----------------------------------------------------
% If you have any question please contact us :
% ccp@cartuja.us.es 
%-----------------------------------------------------
%-----------------------------------------------
%  Main variables description:
%  rls = Rule matrix.
%  p = [A1 B1 C1;A2 B2 C2;...]
%  numRules = Number of Rules.
%  numStates = Number of states.
%  A = Matrix AS that is the sum of the Ai; i=1,...,numRules;
%  mAes = Matrix [A1; A2; A3; ...]
%-----------------------------------------------

rls=FM(1).rls;
numRules=size(rls,1);% Number of files of rls
p=ms2mm(FM,numRules);
numStates=size(p,1)/numRules;
A=zeros(numStates,numStates);
B=eye(numStates);
C=eye(numStates);
D=zeros(numStates,numStates);
mAes = p(:,1:numStates);

%  sum of Ai-> AS
for n=1:numRules
  	  aux= mAes((n-1)*numStates+1:n*numStates,:);
    A = A + aux;
end
G0  = sys2mv(0,A,B,C,D);

mat.numStates=numStates;
mat.numRules=numRules;
mat.A=A;
mat.B=B;
mat.C=C;
mat.D=D;
mat.G0=G0;
mat.FM=FM;