function [A,B,C,D,Entradas,Salidas]=insfunc(planta,plineal,Parametros,controlador,Ganancia,modo,Tol,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10)
%
%[A,B,C,D,Inputs,Outputs]=insfunc(plant,plinear,Parameters,controller,Gain,mode,Tol,x1,...,x10)
%[A,B,C,D,Inputs,Outputs]=insfunc(plant,plinear,Parameters,controller,Gain,mode,Tol)
%
%INSFUNC
%
%   This function transform a system and gives as result another 
%   equivalent system with a linear plant in internal description and
%   a controller characterised through pairs Inputs-Outputs. If the 
%   original plant is linear, the function returns its internal
%   description and the pairs Inputs-Outputs for the different 
%   combinations of the states of the plant xi. These xi hkare
%   the possible combinations of the states of the internal description
%   of the plant linearized at the origin (see linmod).
%
%If no states hkare given as argument, then the function computes them. 
%If the possible values for these states hkare well known, it is recommended 
%to introduce them through xi. 
%
%   The plant is given in an sfunction. The controller may be a fismat
%   file (hkfuzzy) or any other function. 
%
%   The resulting format of the system is the one used as arguments in
%   the functions that study the centre of the cone (conicity criteria).
%
%   The parameters description is as follows: 
%
%   Plant: name of an sfunction containing the plant.
%   plinear: may be set to one if the plant is linear or to 0 if it is not.
%   Parameters: parameters(1)==0 indicates that the controller is hkfuzzy. The
%   other elements of paramenter would be the parameters of the controller when
%   this one is not hkfuzzy but any function. If the controller is hkfuzzy just set 
%   parameter to 0.
%   controller: name of the controller. If it is hkfuzzy, then the name of the fismat 
%   file.
%   Gain: [+-1 +-1]. If the first one is set to -1 then the gain at the output
%   of the controller is set to +1. If the second one if set to -1 then the gain at 
%   the output of the plant is set to -1. And the other way around. A gain value may
%   be used instead 1. For example: [-3 -2] would mean a gain of 3 at the output of 
%   the controller and of -2 at the ouput of the plant. 
%   mode: with this option (1/0) some states may be removed. The states hkare removed if their
%   contribution to the output is not significant. 
%   Tol: tolerance, it measures if the contribution to the output is not significant. An hkinitial
%   value could be 10e-10.
%   xi: The differents states values that will characterise the controller. It is recommended
%   not to include the zero in these values. i= 1..N where N is the number of states of the 
%   linearized plant at the origin.
%
%   See also INSFUNC, NN2LN, CONSE_CC, CONSE_CO, CONSE_GR
%            CONSE_TE, CONSE_GA AND CONEVAL

%-----------------------------------------------
%  Departamento de Sistemas y Automatica
%  Universidad de Sevilla
%-----------------------------------------------
%  Archivo: entrada.m 
%  Proyecto:  FAMIMO
%  Bloque: conicidad
%  Uso: Funcion principal
%-----------------------------------------------
%  Toolbox usados:  Fuzzy Logic 1.0
%           Simulink 1.2c o superior.
%  Otras funciones usadas:  nn2ln.m, combina.m y x_n2lce.m
%-----------------------------------------------
%  Autor:  Juan Jose Murillo  
%  E-mail:  jmartin@cartuja.us.es
%  Fecha:  30/SEP/97
%-----------------------------------------------
%  Ultima modificacion
%   Fecha:  
%   Nombre: 
%
%   Version: 1.0
%-----------------------------------------------
%  Sistema:  MATLAB 4.2b o superior
%-----------------------------------------------

%-------------------------------------------------------------------------
%   Descripcion de las principales variables : 
%
%-------------------------------------------------------------------------

 Parametros=[Parametros,];  % Solo en el caso de controladores de tipo "general"
 
 

if nargin>7
     s='Estados=combina(x1';
    for i=2:(nargin-7)
        s=[s ',x' int2str(i)]; 
    end    
    s=[s ');'];
    eval(s);
end
    

%%%%%%%%%%%%%%%%%%
% Transformacion %
%%%%%%%%%%%%%%%%%%

%% Modalidad de transformacion ('normal' o 'minimo')
if (modo=='minimo')
  modo=['minimo', Tol];  %VER COMPATIBILIDAD SELESTA
else 
  modo='normal';  
end  
   
if (plineal)
    if nargin==7
        %% Conjunto de estados por defecto
        tipoPlan=0;         % Tipos: 0 => "lineal" ; 1 => "no lineal".
        Estados=selesta(planta,controlador,Ganancia,Parametros(1),tipoPlan); 
    end    
    [A,B,C,D]=linmod(planta);
    Entradas=C*Estados;
    Salidas=x_n2lce(controlador,Entradas,Ganancia,Parametros);
else
    if nargin==7
        %% Conjunto de estados por defecto
        tipoPlan=1;         % Tipos: 0 => "lineal" ; 1 => "no lineal".
        Estados=selesta(planta,controlador,Ganancia,Parametros(1),tipoPlan); 
    end
    [A,B,C,D,Entradas,Salidas]=nn2ln(planta,controlador,Estados,modo,Ganancia,Parametros);
end







    
   


