function [num,den]=ss2tm(a,b,c,d,Name,Model);
%SS2TM  Multivariable State-Space to Transfer Matrix conversion. It
%       returns the transfer matrix and if a Name is given a fast_sl
%       blockset TMXxX is created.
%
%       SS2TM(A,B,C,D,Name,Model)  
%       SS2TM(A,B,C,D,Name)
%       SS2TM(A,B,C,D)
%
%       calculates the multivariable transfer function:
%
%                                -1
%              	     H(s) = C(sI-A) B + D
%                      
%       of the system:
%               .
%               x = Ax + Bu
%               y = Cx + Du
%
%       
%       Name corresponds to the name of the transfer matrix to be 
%       created as a fast_sl blockset. 
%       Model corresponds to the model where the transfer matrix
%       will be included.The model has to exist. If no model is 
%       given, then the actual one is used. 	
%
%       The function returns the numerator and denominator 
%       in the way Multivariable Frecuencial Toolbox does:
%       If the Transfer Matrix has m x n elements
%       NUM has m rows and lenght(DEN)*n columns.
%       Each row is divided into n sets of length(DEN)
%       corresponding to the differents inputs. So,
%       each row contains the transfer elements of
%       each input: NUM=[n11,n12,n13...;n21,n22,...;...]
%       DEN is the minimum commom denominator.  
%
%	See also: nd2tm, mv2mvn, mvn2mv, mvn2mvne, mvn2ub, 
%       matfreqs, nl2mvn, nd2tm, tm2nd, tm2ss, ss2tm,tm2nd


%-----------------------------------------------------
% Departamento de Ingenieria de Sistemas y Automatica.
% Universidad de Sevilla 
%-----------------------------------------------------
% File: ss2tm
% Project: FAMIMO
% Block: fast
% Use: 
%-----------------------------------------------------
% toolbox used: 
%
%-----------------------------------------------------
% Authors: Francisco M. Lopez Rodriguez 
% E-mail : pacolope@bart.us.es
% Date:  Oct 1997
%-----------------------------------------------------
% Last update
% Date:
% name: Francisco M. Lopez Rodriguez
% Main changes : 
% Version Beta 0.0
%-----------------------------------------------------
% System : matlab 4.2c or higher
%      simulink 1.3a or higher
%-----------------------------------------------------
% If you have any question please contact us :
% famimo@cartuja.us.es 
%-----------------------------------------------------

narg=nargin;
error(nargchk(4,6,narg));
error(abcdchk(a,b,c,d));

den = poly(a);

%if narg~=7    % for each input 
   [m,n]=size(b);
   iu=1:n;
%end

if narg==5
	Model=get_param(0,'CurrentSystem');
end

[mc,nc] = size(c);
nc1=nc+1;
[md,nd] = size(d);
k=1:nc1;

num= zeros(md, nc1*length(iu));

for ci=1:length(iu)  % for each column
    j=iu(ci);
    for i=1:mc
	num(i,k+(ci-1)*nc1) = poly(a-b(:,j)*c(i,:)) + (d(i,j) - 1) * den;
    end
end

% Size of the transfer matrix.
[TransferSize,checkTS]=size(num);
longden=length(den);

if ( TransferSize == (checkTS/longden ) & narg>4)


if ( TransferSize==3 )	

	% get the minimal realization of the transfer matrix
	[num11,den11]=minreal2(num(1,1:longden),den);
	[num12,den12]=minreal2(num(1,(longden+1):(2*longden)),den);
	[num13,den13]=minreal2(num(1,( (2*longden) +1):(3*longden)),den);
	[num21,den21]=minreal2(num(2,1:longden),den);
	[num22,den22]=minreal2(num(2,(longden+1):(2*longden)),den);
	[num23,den23]=minreal2(num(2,( (2*longden) +1):(3*longden)),den);
	[num31,den31]=minreal2(num(3,1:longden),den);
	[num32,den32]=minreal2(num(3,(longden+1):(2*longden)),den);
	[num33,den33]=minreal2(num(3,( (2*longden) +1):(3*longden)),den);

	if (exist('Model')==0) % Exists the auxiliar block?
		error('Not such a model');
	end
	
	sys=[Model,'/',Name]; % Copy the transfer matrix from fast_sl to Auxblock
	open_system('fast_sl');
	add_block('fast_sl/TM3x3',sys)
	
	% put the correct parameters

	set_param([sys,'/#G11TM3'],'denominator',mat2str(den11));
	set_param([sys,'/#G11TM3'],'numerator',mat2str(num11));
	set_param([sys,'/#G12TM3'],'denominator',mat2str(den12));
	set_param([sys,'/#G12TM3'],'numerator',mat2str(num12));
	set_param([sys,'/#G13TM3'],'denominator',mat2str(den13));
	set_param([sys,'/#G13TM3'],'numerator',mat2str(num13));

	set_param([sys,'/#G21TM3'],'denominator',mat2str(den21));
	set_param([sys,'/#G21TM3'],'numerator',mat2str(num21));
	set_param([sys,'/#G22TM3'],'denominator',mat2str(den22));
	set_param([sys,'/#G22TM3'],'numerator',mat2str(num22));
	set_param([sys,'/#G23TM3'],'denominator',mat2str(den23));
	set_param([sys,'/#G23TM3'],'numerator',mat2str(num23));

	set_param([sys,'/#G31TM3'],'denominator',mat2str(den31));
	set_param([sys,'/#G31TM3'],'numerator',mat2str(num31));
	set_param([sys,'/#G32TM3'],'denominator',mat2str(den32));
	set_param([sys,'/#G32TM3'],'numerator',mat2str(num32));
	set_param([sys,'/#G33TM3'],'denominator',mat2str(den33));
	set_param([sys,'/#G33TM3'],'numerator',mat2str(num33));



end

if ( TransferSize==2 )

	% get the minimal realization of the transfer matrix
	[num11,den11]=minreal2(num(1,1:longden),den);
	[num12,den12]=minreal2(num(1,(longden+1):(2*longden)),den);
	[num21,den21]=minreal2(num(2,1:longden),den);
	[num22,den22]=minreal2(num(2,(longden+1):(2*longden)),den);

	if (exist('Model')==0) % Exists the auxiliar block?
		error('Not such a model');
	end

	
	sys=[Model,'/',Name]; % Copy the transfer matrix from fast_sl to Auxblock
	open_system('fast_sl');
	add_block('fast_sl/TM2x2',sys)
	
	% put the correct parameters
	set_param([sys,'/#G11TM'],'denominator',mat2str(den11));
	set_param([sys,'/#G11TM'],'numerator',mat2str(num11));
	set_param([sys,'/#G12TM'],'denominator',mat2str(den12));
	set_param([sys,'/#G12TM'],'numerator',mat2str(num12));
	set_param([sys,'/#G21TM'],'denominator',mat2str(den21));
	set_param([sys,'/#G21TM'],'numerator',mat2str(num21));
	set_param([sys,'/#G22TM'],'denominator',mat2str(den22));
	set_param([sys,'/#G22TM'],'numerator',mat2str(num22));

end	
end	
