function [a,b,c,d]=tm2ss(name,model);

%TM2SS  Transfer Matrix to Multivariable State-Space conversion.
%
%       [A,B,C,D] = tm2ss(TransferMatrix,Model)  
%       [A,B,C,D] = tm2ss(TransferMatrix)
%       [A,B,C,D] = tm2ss(num,den) 
%
%	TransferMatrix corresponds to the name of the transfer matrix.
%	Model corresponds to the model where the transfer matrix
%	will be included.The model have to exist. If no model is given,
%       then the actual one is used.
%	num and den hkare the system given directly through the matrices.
%
%	See also: nd2tm, mv2mvn, mvn2mv, mvn2mvne, mvn2ub, 
%       matfreqs, nl2mvn, nd2tm, tm2nd, tm2nd, ss2tm

%-----------------------------------------------------
% Departamento de Ingenieria de Sistemas y Automatica.
% Universidad de Sevilla 
%-----------------------------------------------------
% File:	tm2ss
% Project: FAMIMO
% Block: fast
% Use: 
%-----------------------------------------------------
% toolbox used: fast
%
%-----------------------------------------------------
% Authors: Francisco M. Lopez Rodriguez 
% E-mail : pacolope@bart.us.es
% Date:	 
%-----------------------------------------------------
% System : matlab 4.2c or higher
%	   simulink 1.3a or higher
%-----------------------------------------------------
% If you have any question please contact us :
% famimo@cartuja.us.es 
%-----------------------------------------------------

if nargin==1 % last model actived
	model=get_param;
	option=0;
end

if nargin==2
	if ischar(name)
		option=0;
	else
		option=1;
	end
end




if option==0

	TransferSize=isTM(name,model);

	if ( TransferSize==0 )
		error('Not such a transfer matrix');
	end

	name=[model,'/',name]; % Path of the Matrix Transfer from a model

	if ( TransferSize==2 )

		num11=(get_param([name,'/','#G11TM'],'numerator'));
		den11=(get_param([name,'/','#G11TM'],'denominator'));
		%
		num12=(get_param([name,'/','#G12TM'],'numerator'));
		den12=(get_param([name,'/','#G12TM'],'denominator'));
		%
		num21=(get_param([name,'/','#G21TM'],'numerator'));
		den21=(get_param([name,'/','#G21TM'],'denominator'));
		%
		num22=(get_param([name,'/','#G22TM'],'numerator'));
		den22=(get_param([name,'/','#G22TM'],'denominator'));
		%
		open_system('MIMO2x2',[0 0 0 0]);
		model;
		set_param('MIMO2x2/MIMO2x2/#G11TM','numerator',num11);
		set_param('MIMO2x2/MIMO2x2/#G11TM','denominator',den11);
		set_param('MIMO2x2/MIMO2x2/#G12TM','numerator',num12);
		set_param('MIMO2x2/MIMO2x2/#G12TM','denominator',den12);
		set_param('MIMO2x2/MIMO2x2/#G21TM','numerator',num21);
		set_param('MIMO2x2/MIMO2x2/#G21TM','denominator',den21);
		set_param('MIMO2x2/MIMO2x2/#G22TM','numerator',num22);
		set_param('MIMO2x2/MIMO2x2/#G22TM','denominator',den22);

		[a,b,c,d]=linmod2('MIMO2x2');
		[a,b,c,d]=hkminreal(a,b,c,d);
		close_system('MIMO2x2',0);
	end

	if ( TransferSize==3 )

		num11=(get_param([name,'/','#G11TM3'],'numerator'));
		den11=(get_param([name,'/','#G11TM3'],'denominator'));
		num12=(get_param([name,'/','#G12TM3'],'numerator'));
		den12=(get_param([name,'/','#G12TM3'],'denominator'));	
		num13=(get_param([name,'/','#G13TM3'],'numerator'));
		den13=(get_param([name,'/','#G13TM3'],'denominator'));

		num21=(get_param([name,'/','#G21TM3'],'numerator'));
		den21=(get_param([name,'/','#G21TM3'],'denominator'));
		num22=(get_param([name,'/','#G22TM3'],'numerator'));
		den22=(get_param([name,'/','#G22TM3'],'denominator'));
		num23=(get_param([name,'/','#G23TM3'],'numerator'));
		den23=(get_param([name,'/','#G23TM3'],'denominator'));

		num31=(get_param([name,'/','#G31TM3'],'numerator'));
		den31=(get_param([name,'/','#G31TM3'],'denominator'));
		num32=(get_param([name,'/','#G32TM3'],'numerator'));
		den32=(get_param([name,'/','#G32TM3'],'denominator'));
		num33=(get_param([name,'/','#G33TM3'],'numerator'));
		den33=(get_param([name,'/','#G33TM3'],'denominator'));

		open_system('MIMO3x3',[0 0 0 0]);
		model;
		set_param('MIMO3x3/MIMO3x3/#G11TM3','numerator',num11);
		set_param('MIMO3x3/MIMO3x3/#G11TM3','denominator',den11);
		set_param('MIMO3x3/MIMO3x3/#G12TM3','numerator',num12);
		set_param('MIMO3x3/MIMO3x3/#G12TM3','denominator',den12);
		set_param('MIMO3x3/MIMO3x3/#G13TM3','numerator',num13);
		set_param('MIMO3x3/MIMO3x3/#G13TM3','denominator',den13);

		set_param('MIMO3x3/MIMO3x3/#G21TM3','numerator',num21);
		set_param('MIMO3x3/MIMO3x3/#G21TM3','denominator',den21);
		set_param('MIMO3x3/MIMO3x3/#G22TM3','numerator',num22);
		set_param('MIMO3x3/MIMO3x3/#G22TM3','denominator',den22);
		set_param('MIMO3x3/MIMO3x3/#G23TM3','numerator',num23);
		set_param('MIMO3x3/MIMO3x3/#G23TM3','denominator',den23);

		set_param('MIMO3x3/MIMO3x3/#G31TM3','numerator',num31);
		set_param('MIMO3x3/MIMO3x3/#G31TM3','denominator',den31);
		set_param('MIMO3x3/MIMO3x3/#G32TM3','numerator',num32);
		set_param('MIMO3x3/MIMO3x3/#G32TM3','denominator',den32);
		set_param('MIMO3x3/MIMO3x3/#G33TM3','numerator',num33);
		set_param('MIMO3x3/MIMO3x3/#G33TM3','denominator',den33);

		[a,b,c,d]=linmod2('MIMO3x3');
		[a,b,c,d]=hkminreal(a,b,c,d);
		close_system('MIMO3x3',0);
	end
end

if option
	den=model;
	num=name;
	[md,nd]=size(den);
	[mn,nn]=size(num);

	nElementsNumerator=nn/nd;
	for k1=1:mn
		for k2=1:nElementsNumerator
			column=(k2-1)*nd+1;
			newNumerator{k1,k2}=num(k1,column:column+nd-1);
			denominator{k1,k2}=den;
		end
	end

	sys=hktf(newNumerator,denominator);
	sys=hkminreal(sys);
	[a,b,c,d]=hkssdata(sys);
end
		


