function plotmfs(mfs,opt)
% PLOTMFS    Plot membership functions.
%    PLOTMFS(MFS) plots membership functions. MFS can be a numerical
%    array, a cell array or a fuzzy model structure FM.

% Copyright (c) Robert Babuska, 1998.

if isnumeric(mfs),
   dom = [min(mfs(:,2)) max(mfs(:,5))];
   dom = (dom(1) : (dom(2)-dom(1))/500 : dom(2))';
   if nargin == 1, 
      plot(dom,mgrade(dom,mfs));
   else
      plot(dom,mgrade(dom,mfs),opt);
   end;   
elseif isstruct(mfs),
   FM = mfs;
	vars = antename(FM);
   for i = 1 : FM.no,
      figure(i); clf; 
      if mfs.ante(i) == 2,
         [c,nvar] = size(FM.mfs{i});
         for k = 1 : nvar;
            switch nvar,
               case 1, subplot(1,1,1);
               case {2,3}, subplot(nvar,1,k);
               otherwise, subplot(ceil(nvar/2),2,k);
            end;      
            plotmfs(FM.mfs{i}{k});
            xlabel(vars{i}{k});
         end;   
      else
         [c,nvar] = size(FM.V{i});
         for k = 1 : nvar;
            dom = [FM.zmin{i}(k) FM.zmax{i}(k)];
            dom = (dom(1) : (dom(2)-dom(1))/500 : dom(2))';
            for j = 1 : c,
               xx = ones(501,1)*FM.V{i}(j,:);
               xx(:,k) = dom;
               ff = fgrade(FM,xx,i);
               f(:,j) = ff(:,j);
            end;
            switch nvar,
               case 1, subplot(1,1,1);
               case {2,3}, subplot(nvar,1,k);
               otherwise, subplot(ceil(nvar/2),2,k);
            end;      
            if nargin == 1, 
               plot(dom,f);
            else
               plot(dom,f,opt);
            end;   
            xlabel(vars{i}{k});
         end;
      end;
   end;   
elseif iscell(mfs),
   n = length(mfs);
   for i = 1 : n,
      switch n,
         case 1, subplot(1,1,1);
         case {2,3}, subplot(n,1,i);
         otherwise, subplot(ceil(n/2),2,i);
      end;      
   	if nargin == 1, 
      plotmfs(mfs{i});
   	else
      plotmfs(mfs{i},opt);
	   end;   
   end;
end;

