%CONLL  Lazy Learning Algorithm: Constant local models.  
%  
%   Ultra-fast version of the lazy learning algorithm.
%  
%  
%   Local models                   constant
%   Kernel functions               rectangular
%   Identification                 recursive mean and variance
%   Metric                         L1
%   Model selection                Minimum of leave-one-out error
%  
%   -----------------------------------------------------------------------
%     
%     
%     How to compile:
%     If a C compiler is correctly installed, and if matlab knows 
%     its path, the function can be compiled from the matlab
%     prompt, as follows:
%     
%  		>> mex -O conLL.c
%     
%     How to use:
%     From matlab, the resulting mex file can be called using 
%     the following syntax.
%     
%  		>> [h,s,t,k,H,S,T,I] = conLL(X,Y,Q,id_par);
%     
%     where 
%  	 INPUT:
%              X[n,m]              Examples: Input
%              Y[n,1]              Examples: Ouput
%              Q[q,m]              Query points
%              id_par[2,1]         Identification parameters = [idm;idM];
%  
%  	 OUTPUT:
%              h[q,1]              Prediction with the selected number of 
%                                  neighbors
%              s[q,1]              Estimated variance of the prediction.
%    --------- t[0,0] ------------ DUMMY VARIABLE: for compatibility 
%                                  pourposes
%              k[q,1]              Selected number of neighbors
%              H[idM,q]            All the predictions obtained using a 
%                                  number of neighbors in the range 1:idM
%              S[idM,q]            Estimated variance of ALL the predictions
%    --------- T[0,0,0] ---------- DUMMY VARIABLE: for compatibility
%                                  pourposes
%              I[idM,q]            Index of idM-nearest-neighbors of each
%                                  query point
%  
%     
%     The identification parameters are [idm;idM]: 
%     the minimum and maximum number of examples used in the 
%     identification.
%     
%     The function accept also a 5th input, a vector W[m,1] of weights
%     that can be used to rescale the dimensions.
%

%   The Lazy Learning Toolbox --- Version 1.0:
%   -------------------------------------------------------------------------
%   Copyright (c) 1999 by Mauro Birattari & Gianluca Bontempi
%   -------------------------------------------------------------------------
%  
%               Mauro Birattari                   Gianluca Bontempi
%                   IRIDIA                             IRIDIA 
%       Universite' Libre de Bruxelles     Universite' Libre de Bruxelles
%              mbiro@ulb.ac.be                    gbonte@ulb.ac.be
%  
%   -------------------------------------------------------------------------
%   Mao: Feb 5, 1999
