function r = mkplot(c,p,a,b,k)
%MKPLOT Display the influence of a center prototype couple
%    
%    MKPLOT(C,P,A,B,K) is a basic plotting utility used to
%    display the influence of a center prototype couple. C is
%    the center, P the prototype, A and B, the weights and K
%    the distance.
%    
%    See also: MKMEANS
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Display the influence of a center prototype couple
%
%   @synopsis	mkplot(c,p,a,b,k)
%   @description  is a basic plotting utility used to display the
%	influence of a center prototype couple. <code>c</code> is the center, <code>p</code> the prototype,
%	<code>a</code> and <code>b</code>, the weights and <code>k</code> the distance.
%
%   @see mkmeans
%
%MAN_PAGE_END


[x,y] = mksplot(a,b,k);

d = sqrt((c(1) - p(1))^2 + (c(2) - p(2))^2);

x = x * d;
y = y * d;

ct = (p(1) - c(1)) / d;
st = (p(2) - c(2)) / d;

rota = [ct -st;st ct];

rp = rota * [x';y'];

g = (c + p)/2;

rp = rp + g(:,ones(size(rp,2),1));

r = plot(rp(1,:),rp(2,:));

function [x,y] = mksplot(alpha,beta,k);

r = k;
p = [];
for i= 0:40,
	theta = i/20 * pi;
	bct = num2str(2 * cos(theta) * beta);
	bsq = num2str(beta^2);
	act = num2str(2 * cos(theta) * alpha);
	asq = num2str(alpha^2);
	r = fzero([num2str(alpha) '*sqrt(' bsq '+x^2+' bct ' * x) + ' num2str(beta) '*sqrt(' asq '+x^2 - ' act '*x ) -' num2str(k)],r);
	p = [p;[theta r]];
end
[x,y]=pol2cart(p(:,1),p(:,2));
