function d = uscanf(file, delimiter, format, class_position)
%USCANF Universal scanning of an ASCII file formatted in
%    columns of different types
%    
%    D = USCANF(FILE, DELIMITER, FORMAT, CLASS_POSITION) The
%    strings are put into cell arrays : use braces "{}" to
%    access the strings. (more information, see 13-18 of
%    'Using Matlab') USCANF allows undetermined blanks between
%    the delimiters USCANF uses the bad 'fgets', so it may be
%    slow for large problems Inputs : file	  : ascii
%    filename string string	: classical format string such as
%    fscanf and others. format     : a string with 'n' for a
%    numerical column and 's' for a string column
%    class_position : integer that indicates the column where
%    are the classes Ouputs :  d.data	: values of the
%    numerical attributes%	d.sdata : values of the nominal
%    attributes (cell array) d.classes : values of the classes
%    for each example
%    
%    See also: ALSO 
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	Universal scanning of an ASCII file formatted in columns of different types.
%
%   @synopsis	d = uscanf(file, delimiter, format, class_position)
%   @description  The strings are put into cell arrays : use braces "{}" to access the strings.
%    (more information, see 13-18 of 'Using Matlab')
%    USCANF allows undetermined blanks between the delimiters
%    USCANF uses the bad 'fgets', so it may be slow for large problems
%
%   Inputs :
%	file	: ascii filename string
%	string	: classical format string such as fscanf and others.
%	format	: a string with 'n' for a numerical column and 's' for a string column
%			
%	class_position : integer that indicates the column where are the classes
%
%   Ouputs : 
%	d.data	: values of the numerical attributes%	d.sdata	: values of the nominal attributes (cell array)
%	d.classes : values of the classes for each example
%
%    @example
%       Given a 3-columns file 'myfile.dat', each column separated with a semi-colon : 
%	
%       12.256,   1.6544 ,  date             
%       156.95 , 94.324 ,  internet
%       4,45,        names
%
%       d = uscanf('myfile.dat', ',', '2n1s', 3);
%
%   @see also 
%
%MAN_PAGE_END

classes=[];
sdata={};
data=[];
disp('In progress...')
fid = fopen(file,'r');
if (nargin < 3)
	error('Not enough input arguments.')
end
j=1; % index of current line in the file

while 1
	line=fgets(fid);
	if (line~=-1)
		i=1;   % index of current output
		ii=1;		
		iii=1;		
		if isletter(format(2))			
			x=str2num(format(1));
			% counter for format			
			y=2;                    % position in format		
		else			
			x=str2num(strcat(format(1),format(2)));			
			y=3;		
		end
		while 1
			[token,line]=strtok(line, delimiter);		
			if (length(token)~=0)
				if i==class_position				    					
			%		if strcmp(format(y),'n')
			%			classes(j) = str2num(token);					 				
			%		elseif strcmp(format(y),'s')
						classes{j} = token;					
			%		else 
			%			xxx = sprintf('Bad formatting, line %d, column %d',j,i); 						
			%			error(xxx);					
			%		end				
				else					
					if strcmp(format(y),'n')
						data(j,ii) = str2num(token);					 				
						ii=ii+1;					
					elseif strcmp(format(y),'s')
						sdata{j,iii} = deblank(token);											
						iii=iii+1;
					else 						
						xxx = sprintf('Bad formatting, line %d, column %d',j,i); 						
						error(xxx);				
					end				
				end				
				x=x-1;								
				if x==0					
					if y~=length(format)			
						if isletter(format(y+2))							
							x=str2num(format(y+1));   % counter for format							
							y=2+y;           % position in format						
						else							
							x=str2num(strcat(format(1+y),format(2+y)));							
							y=y+3;							
						end				 				 							
					else						
						x=str2num(format(1));						
						y=2;						
					end				
				end											
				i=i+1;
				else break 
			end
		end
		j=j+1;
	else break 
end
end
fclose(fid); 

d=dataset(data,sdata,classes');
