/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 * *************************************/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <memory.h> 
#include "BAGFSC45.h"
#include "DataSet.h"
#include "tools.h"
//#include <crtdbg.h>

/*
void test(DataSet *D)
{
	int i;
	FILE *f;
	C45 *CurrentTree;
	Boolean *FS=(Boolean*)malloc(D->MaxAtt*sizeof(Boolean));

    for (i=0; i<D->MaxAtt; i++) FS[i]=1;
	printf("Building 1 tree\n");
	CurrentTree = new C45(D,FS,1); 
	f=fopen("arbre_test.txt","w");
	printf("Saving tree\n");
    CurrentTree->save(f,D->MinClass);
	fclose(f);
	delete(CurrentTree);
	free(FS);
	delete(D); getchar(); exit(0);
};
*/
int main(int argc, char **argv)
{
	BAGFSC45 *c=NULL;
	DataSet *AllItem;

	if ((argc<2)||(argc>5))
	{
		printf("SYNTAX: kc_generate <DataSet_file> [<K> <B> [<output_BAGFSC45_file>]]\n\n"
			   "The goal of this program is to create a new classifier (a simple vote between\n"
			   "different descision trees). If <K> is nul or not specified then calculation\n"
			   "to find optimal K is done. If <K> is -1 then we will use all the features. If\n"
               "<output_BAGFSC45_file> is not specified then the resulting classifier name\n"
			   "will be based on the current date and time.\n");
		exit(255);
	};    
	
    AllItem=new DataSet(argv[1]);
    printf("\nRead %d cases (%d attributes)\n",AllItem->nItem, AllItem->MaxAtt);
    
//    FILE *f=fopen("test.txt","w"); AllItem->save(f); fclose(f); exit(0);
	// test tree generation engine:
//	test(AllItem);

    initRandom();

	//  Build decision trees  
    switch (argc)
    {
    case 5:
    case 4:	c=new BAGFSC45(AllItem,atol(argv[2]),atol(argv[3])); break;
    case 3: c=new BAGFSC45(AllItem,atol(argv[2])); break;
    case 2: c=new BAGFSC45(AllItem); break;
    }

    if (argc==5) ((Classifier*)c)->save(argv[4]);
   	else ((Classifier*)c)->save(); 
    	
	printf("Trees generation terminated successfully.\n"
           "Optimal K=%i\nOptimal B=%i\n", c->K, c->B );

    printf("Estimation of error rate: %3.1f%%\n",100* c->errorEstimate());

    //c->createAndSaveConfMatrix(AllItem,"confusion_matrixV.txt");

    delete(c); delete(AllItem);
	// getchar();
	return 0;
};
