/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 ***************************************/

#include <stdio.h>
#include <stdlib.h>
#include <memory.h> 
#include "RRBAGFSC45.h"
#include "DataSet.h"
#include "tools.h"
//#include <crtdbg.h>

int main(int argc, char **argv)
{
	Classifier *c;
	DataSet *AllItem;

	if ((argc<2)||(argc>5))
	{
		printf("SYNTAX: kc_RRgenerate <DataSet_file> [<K> <B> [<output_RRBAGFSC45_file>]]\n\n"
			   "The goal of this program is to create a new classifier which is a round robin\n"
			   "vote between different descision trees). If <K> is nul or not specified then \n"
			   "calculation to find optimal K is done. If <K> is -1 then we will use all the\n"
               "features. If <output_RRBAGFSC45_file> is not specified then the resulting\n"
			   "classifier name will be based on the current date and time.\n");
		exit(255);
	};    
	
    AllItem=new DataSet(argv[1],1);
    printf("\nRead %d cases (%d attributes)\n",AllItem->nItem, AllItem->MaxAtt);

	//  Build decision trees  
    switch (argc)
    {
    case 5:
    case 4:	c=new RRBAGFSC45(AllItem,atol(argv[2]),atol(argv[3])); break;
    case 3: c=new RRBAGFSC45(AllItem,atol(argv[2])); break;
    case 2: c=new RRBAGFSC45(AllItem); break;
    }

	if (argc==5) c->save(argv[4]);
	else c->save(); // ,AllItem->MinClass);
	
	printf("Round Robin Trees generation terminated successfully.\n");

//    c->createAndSaveConfMatrix(AllItem,"confusion_matrixV.txt");

	delete(c); delete(AllItem);
	// getchar();
	return 0;
};
