/***************************************
 * copyright (c) Vanden Berghen Frank  *
 * V 1.2                               *
 * *************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "definitions.h"
#include "classifier.h"
#include "textUtils.h"
#include "BAGFSC45.h"
#include "RRBAGFSC45.h"

#ifdef __NO_DATASET__
#define __EVAL_ONLY__
#endif

#ifdef __INSIDE_GVB_SERVER__

// #include "general_params.h"

Classifier::Classifier(): name(NULL), nUtilisateur(0), fin(0)
{ 
    pthread_mutex_init(&Cmutex,NULL);
};

Classifier::~Classifier()
{
    if (name) free(name); 
    pthread_mutex_destroy(&Cmutex);
};

void Classifier_lock(Classifier *C)
{
    pthread_mutex_lock(&C->Cmutex);
    C->nUtilisateur++;
    pthread_mutex_unlock(&C->Cmutex);
}

void Classifier_unlock(Classifier *C)
{
    pthread_mutex_lock(&C->Cmutex);
    if (((--C->nUtilisateur)<=0)&&(C->fin==1))
    {
        pthread_mutex_unlock(&C->Cmutex);
        delete(C); return;
    };
    pthread_mutex_unlock(&C->Cmutex);
};

void Classifier_delete(Classifier *C)
{
    pthread_mutex_lock(&C->Cmutex);
    if (C->nUtilisateur<=0) 
    { 
        pthread_mutex_unlock(&C->Cmutex);
        delete(C); return; 
    };
    C->fin=1;
    pthread_mutex_unlock(&C->Cmutex);
};

#else

Classifier::Classifier(): name(NULL){};
Classifier::~Classifier(){ if (name) free(name); };

#endif

#ifndef __NO_DATASET__

#define ClassTest(Case)	 (*((ClassNo*)(ItemTest->Item[Case]+MaxAtt)))
int Classifier::Different(Classifier *b, DataSet *ItemTest)
{
	Boolean N1vrai, N2vrai;
	int M10=0,M01=0,M00=0,M11=0,i,MaxAtt=ItemTest->MaxAtt;
	double factice;

	for (i=0; i<ItemTest->nItem; i++)
	{
		N1vrai=(ClassTest(i)==eval(ItemTest->Item[i],&factice));
		N2vrai=(ClassTest(i)==b->eval(ItemTest->Item[i],&factice));
		if (  N1vrai            ) M00++;
		if (  N2vrai            ) M11++;
		if (( N1vrai)&&(!N2vrai)) M10++;
		if ((!N1vrai)&&( N2vrai)) M01++;
	};

	if (M10+M01<=20) return 0;
	if ((SQR(ABS(M10-M01)-1)/(M10+M01))<3.841459) return 0;  
	if (M00>M11) return 1; 
	return 2;
};

#define RealClass(Case) (*((ClassNo*)(tmp[Case]+tmp2)))
void Classifier::UpdateConfusionMatrix(int *confusionMat, DataSet *D, char verbose)
{
	int MaxClass=D->MaxClass, MinClass=D->MinClass,tmp2=D->MaxAtt,l;
	double **tmp=D->Item; 

    if (verbose) printf("Updating Confusion Matrix (1 point=500 cases).\n");
	for (l=0; l<D->nItem; l++)
    {
		//  Evaluation:	
		confusionMat[RealClass(l)+MaxClass*(eval(tmp[l],NULL)-MinClass)]++;
        if (verbose&&((l%500)==0)) { printf("."); fflush(stdout); }
	};
    if (verbose) printf("\n");
};

double Classifier::kappa(int *conf, DataSet *D)
{
	int n=0,MaxClass=D->MaxClass,i,l;
	double teta1=0,teta2=0,tetas,tetap;

	for (i=0; i<SQR(MaxClass); i++) n+=conf[i];

    for (l=0; l<MaxClass; l++)
    {
       teta1+=conf[l*(MaxClass+1)];
       tetas=0;
       for (i=0; i<MaxClass; i++) tetas+=conf[l*MaxClass+i];
       tetap=0;
       for (i=0; i<MaxClass; i++) tetap+=conf[i*MaxClass+l];
       teta2+=tetas*tetap;
    };
    teta1/=n;
    teta2/=SQR(n);
    return (teta1-teta2)/(1-teta2);
};

double Classifier::kappa(DataSet *D)
{
    double r;
    int SQRMaxClass=SQR(D->MaxClass);
    int *conf=(int*)malloc(SQRMaxClass*sizeof(int));
    memset(conf,0,SQRMaxClass*sizeof(int));
    UpdateConfusionMatrix(conf, D);
    r=kappa(conf,D);
    free(conf);
    return r;
};

void Classifier::createAndSaveConfMatrix(DataSet *D, char *filename)
{
    int MaxClass=D->MaxClass,*cm=(int*)malloc(MaxClass*MaxClass*sizeof(int));
	memset(cm,0,MaxClass*MaxClass*sizeof(int));
	UpdateConfusionMatrix(cm,D, 1);
	SaveConfusionMatrix(filename,cm,D);
	printf("Confusion Matrix saved.\n");
}

void Classifier::SaveConfusionMatrix(char *filename, int *conf, DataSet *D)
{
	FILE *f;
	int sum=0,MinClass=D->MinClass,MaxClass=D->MaxClass,i,l;
	double t,s=0;

	for (i=0; i<MaxClass; i++)
		sum+=conf[i*(MaxClass+1)];

        t=kappa(conf,D);
	f=fopen(filename,"w");
	fprintf(f,"percentage of good classification= %f %%\n"
	          "percentage of bad  classification= %f %%\n"
	          "kappa= %f %%\n"
		      "error percentage per classes ",		      
		      ((double)sum)/D->nItem*100,100-((double)sum)/D->nItem*100,t*100);
    if (MinClass>0) fprintf(f,"(The first %i classe(s) have been omitted) =\n",MinClass);
    else fprintf(f,"= \n");    
	for (i=0; i<MaxClass; i++)
	{
	   sum=0;
	   for (l=0; l<MaxClass; l++)
	       if (i!=l) sum+=conf[l*MaxClass+i];
	   s+=t=((double)sum)/(sum+conf[i*(MaxClass+1)])*100;
	   fprintf(f,"  for classe %i: %7.2f %%\n",i+MinClass,t);
	};
	fprintf(f,"mean error percentage per classe: %f %%\n"
	          "A(i=Line=predicted class, j=Column=real class)=number of time that an object\n"
	          "                                               belonging to class j has been\n"
	          "                                               classified in class i.\n"
              "A = \n",s/MaxClass);
    if (MinClass>0)
    {
        fprintf(f,"(The first %i column(s) and the first %i line(s) are filled with zeros and have\n"
        "been omited)\n",
        MinClass,MinClass);
    }
    sum=0;
    for (i=0; i<MaxClass*MaxClass; i++) sum+=conf[i];
	for (i=0; i<MaxClass; i++)
	{
		for (l=0; l<MaxClass; l++)
			fprintf(f,"  %8.7f",((double)conf[i*MaxClass+l])/sum);
		fprintf(f,"\n");
	};
	fclose(f);
};

#endif

#ifndef __EVAL_ONLY__

void Classifier::save(char *name)
{
	char *outputname,buf[300];
    if (name) outputname=name;
    else
    {
        struct tm *timev;
        time_t t;
        t=time(NULL);
        timev=localtime(&t);
        outputname=buf;
        sprintf(buf,"CL_%4i%02i%02i%02i%02i%02i.txt",timev->tm_year+1900,timev->tm_mon+1,
                timev->tm_mday,timev->tm_hour,timev->tm_min,timev->tm_sec);
    }
    FILE *f=fopen(outputname,"wb");
    save(f);
	fclose(f);
}

#endif

Classifier *NewClassifier(char *filename)
{
    Classifier *c;
    FILE *stream;
    GetRidOfTheEOL(filename);
    if ((stream=fopen(filename,"r"))==NULL)
	{
		printf("Classifier file '%s' not found.\n",filename); exit(237);
	};
    c=NewClassifier(stream, filename);
    fclose(stream);
    return c;
}

Classifier *NewClassifier(FILE *stream, char *filename)
{	
    Classifier *c;
    char buffer[300],*tline=buffer;
    Boolean ok=0;

	fgets(tline,300,stream);
    if (strncmp(tline,"BAGFS Trees v1.00",17)==0)
    {
        c=new BAGFSC45(stream);
        ok=1;
    };
    if (strncmp(tline,"Round Robin BAGFS Trees v1.00",29)==0)
    {
        c=new RRBAGFSC45(stream);
        ok=1;
    };
    if (strncmp(tline,"Stacked Round Robin BAGFS Trees v1.00",37)==0)
    {
    	fgets(tline,300,stream);
        if (strncmp(tline,"Round Robin BAGFS Trees v1.00",29)==0)
        {
            c=new StackedRRBAGFSC45(stream);
            ok=1;
        }
    };
    if (strncmp(tline,"Boosted Trees v1.00",19)==0)
    {
        c=new BoostedC45(stream);
        ok=1;
    };
/*
    if (strncmp(tline,"BAGFS Trees v1.00",17)==0)
    {
        c=new BAGFSC45(stream,nClasses,nfeatures);
        ok=1;
    };
*/
    if (ok)
    {
        if (!filename) c->name=NULL;
        else
        {
            c->name=(char*)malloc(strlen(filename)+1);
            if (c->name==NULL)
            {
                fprintf(stderr,"Classifier: out of memory.\n");
                exit(210);
            };
            strcpy(c->name,filename);    
        }
        return c;
    };
    fprintf(stderr,"classifier type not recognised.\n");
    exit(189);
    return NULL;
};

