#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

#define MYMIN(a,b) ((a<b)?a:b)
#define MYMAX(a,b) ((a<b)?b:a)
#define MY_BUFFER_SIZE 1000000

int main(int argc,char **argv)
{
    char HEX[16]={'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};    
    char *b1,*b2;
    unsigned long int buffLength,fileLength,curPos,i;
    FILE *f1,*f2;

    if (argc!=3)
    {
        printf("Binary File Compare.\n\n"
               "USAGE: FC <file1> <file2>\n\n"
               "FC will compare <file1> and <file2> and give\n"
               "you the offset of the first differences.\n");
        return 255;
    };

    f1=fopen(argv[1],"rb");
    if (!f1)
    {
        printf("first file not found.\n");
        return 255;
    }
    f2=fopen(argv[2],"rb");
    if (!f2)
    {
        printf("second file not found.\n");
        return 255;
    }

    fseek(f1,0,SEEK_END);
    buffLength=ftell(f1);
    fseek(f2,0,SEEK_END);
    fileLength=ftell(f2);

    if (buffLength!=fileLength)
    {
        printf("size does not match.\n");
        return 255;
    }
    
    fseek(f1,0, SEEK_SET);
    fseek(f2,0, SEEK_SET);

    buffLength=MYMIN(buffLength,MY_BUFFER_SIZE);
    b1=(char*)malloc(MYMAX(buffLength,9));
    b2=(char*)malloc(buffLength);
 
    printf("Starting...\n");
    curPos=0;
    while (curPos<fileLength)
    {
        i=MYMIN(buffLength,fileLength-curPos);
        fread(b1,i,1,f1);
        printf("$");
        fread(b2,i,1,f2);
        printf("#");
        if (memcmp(b1,b2,i))
        {
            i=0;
            while (b1[i]==b2[i]) i++;
            curPos+=i;
            printf("\nmissmatch at the offset %i [",curPos);
            b1[8]='\0';
            for (i=0; i<8; i++)
            {
                b1[7-i]=HEX[curPos&15];
                curPos>>=4;
            }
            printf(b1); printf("].\n");
            return 255;
        }
        curPos+=buffLength;
    }
    free(b1);
    free(b2);
    printf("\nfiles identical.\n");
    return 0;
}