#ifndef __INCLUDE_MATHUTILS__
#define __INCLUDE_MATHUTILS__

#define SWAP(a,b) {tempr=(a); (a)=(b); (b)=tempr;}
#define SQR(a) ((a)*(a))
#define SIGN(a) ((a)<0?-1:1)
#define ISINT(a) (fabs(a-floor(a+0.5))<1e-4)

#define maxDWORD 4294967295 //2^32-1;
#define INF 1.7E+308 
#define EOL 10

double rand1();
void initRandom();


/*======================table object =================================*/
class Table
{
  public:
    double **p;
    int n,m,extention;
        
    Table(int _m,int _n); //m=ligne; n=colonne
    ~Table();
    Table(char *filename,int _n);
    void save(char *filename,char ascii);
    void extend();
    void exactshape();
    double *operator [](int i);
};

/*======================vector object =================================*/
class Vector
{
  public: 
    double *p;
    int n,extention;
    Vector(int _n);
    Vector(Vector *v);
    ~Vector();
    void extend();
    void exactshape();
    double &operator [](int i);
};

/*======================vectorI object==================================*/

class VectorI
{
   public:
    int *p;
    int n,extention;
    VectorI(int _n);
    VectorI(VectorI *v);
    ~VectorI();
    void extend();
    void exactshape();    
    int &operator [](int i);
};

#endif
