#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "mathutil.h"
#include "Lazy.h"

double fRosenbrock(double x0, double x1)
{
    return  100*  SQR(x1-SQR(x0))+SQR(1-x0);
};

#define SIZE .5
#define DBSIZE 800

int main()
{
    int i;
    
    Table t(DBSIZE,3);
    initRandom();
    for (i=0; i<DBSIZE; i++)
    {
        t[0][i]=rand1()*SIZE-SIZE/2;
        t[1][i]=rand1()*SIZE-SIZE/2;
        t[2][i]=fRosenbrock(t[0][i],t[1][i]);
    }
    VectorI kernel(6);
/*
    kernel[0]=2;
    kernel[1]=3;
    kernel[2]=2;
    kernel[3]=4;
    kernel[4]=2;
    kernel[5]=3;
*/
    kernel[0]=0;
    kernel[1]=0;
    kernel[2]=3;
    kernel[3]=3;
    kernel[4]=0;
    kernel[5]=0;

    VectorI comb(3);
    comb[0]=0;
    comb[1]=1;
    comb[2]=0;

    Lazy *l=new Lazy(&t,&kernel);
    l->setComb(&comb);
//    l->setComb(2);

    double q[2],r,rr,err,tot=0;

    for (i=0; i<200; i++)
    {
        q[0]=rand1()*SIZE-SIZE/2;
        q[1]=rand1()*SIZE-SIZE/2;
        rr=fRosenbrock(q[0],q[1]);
        l->eval(q,&r,NULL,&err);
        printf("q[0]=%f q[1]=%f r=%f realR=%f diff=%f err=%f\n",
                q[0],q[1], r, rr, r-rr, err);
        tot+=fabs((r-rr)/rr);
    }
    printf("\nmean regression error on 200 unseen cases:%f\n",tot/200);
    delete l;
    getchar();
	return 0; 
	
}
