clear all; close all; clc;

load diabetes

X=diabetes.x;
y=diabetes.y;

verbosity=2;

[bbest,b1,sqError,cHat] = larsMatlab(X,y,'E',-1,1,verbosity);
clear mex;
s1=sum(abs(b1),2)/sum(abs(b1(end,:)));

g=figure;
SUBPLOT(1,2,1);
plot(sqError);
title('Squared Error');
SUBPLOT(1,2,2);
plot(cHat);
title('Max Target correlation');
set(g,'position',[ 351 79 1036 375 ]);

g=figure;
plot(s1, b1, '.-');
axis tight;
title('Least Angle Regression (LASSO)');
set(g,'position',[ 601 464 584 488 ]);

sprintf('The classical "diabetes" example.\nThe best model is:')
bbest'
