function display(d)
%DISPLAY displays the dataset object
%    
%    DISPLAY(D) displays the dataset object D.
%    
%    

%MAN_PAGE_BEGIN
%
%   @purpose	displays the dataset object
%
%   @synopsis	display(d)
%   @description  displays the dataset object <code>d</code>.
%
%MAN_PAGE_END

% By Antoine Duchateau. All Rights Reserved.
% Written: 19/03/99

%first divide in chunks 
cn=5;ln=20;
ld = size(d,1);
cd = size(d,2);
chkSiz=[ln cn];

disp(' ');
disp([inputname(1),' = ']);
disp(' ');

nsep = [find(strcmp(d.vartypes,'continuous')) find(strcmp(d.vartypes,'discrete'))];
ssep = [find(strcmp(d.vartypes,'symbolic'))];
classnum = [find(strcmp(d.vartypes,'class'))];

extsymbols = d.symbols;     %%% missing data treatment
for i=1:length(extsymbols),
   extsymbols{i}=[extsymbols{i} {'NaN'}];   
   if strcmp(d.vartypes{i},'symbolic')
      x=find(isnan(d.data(:,i)));
      d.data(x)=length(extsymbols{i});
   end   
end



nformat = '%8.0f | ';
for i=1:cn,
   nformat = [nformat '%8.4f '];
end

if isempty(classnum),
   nformat = [nformat '|\n'];
else
   nformat = [nformat '| %c%c%c%c%c%c%c%c\n'];
end

sformat = '%8.0f | ';
for i=1:cn,
   sformat = [sformat '%c%c%c%c%c%c%c%c '];
end

if isempty(classnum),
   sformat = [sformat '|\n'];
else
   sformat = [sformat '| %c%c%c%c%c%c%c%c\n'];
end

tformat = '\n         | ';
for i=1:cn,
   tformat = [tformat '%c%c%c%c%c%c%c%c '];
end
tformat = [tformat '|\n'];

tnformat='';
tsformat='';
ttnformat='';
ttsformat='';


%try,
for i=1:ln:size(d,1),
   dlim = min(i+ln-1,size(d,1));
   
   nd = get_data(d,i:dlim);
   if (~isempty(classnum)) & any(isnan(nd(:,classnum))),
      nd(find(isnan(nd(:,classnum))),classnum) = length(extsymbols{classnum});
   end
   
   if ~isempty(nd),
      for j=1:cn:size(nsep,2),
         if j+cn-1 <= size(nsep,2),
            fprintf(tformat,cut8(d.variables(nsep(j:j+cn-1))));
            if isempty(classnum),
               fprintf(nformat,[d.labels(i:dlim) nd(:,nsep(j:j+cn-1))]');
            else
               fprintf(nformat,[d.labels(i:dlim) nd(:,nsep(j:j+cn-1)) double(cut8(extsymbols{classnum}(nd(:,classnum))'))]');
            end
         else
            if isempty(tnformat),
               nwd = size(nsep,2) - j + 1;
               
               tnformat = '%8.0f | ';
               for ii=1:nwd,
                  tnformat = [tnformat '%8.4f '];
               end
               if isempty(classnum),
                  tnformat = [tnformat '|\n'];
               else
                  tnformat = [tnformat '| %c%c%c%c%c%c%c%c\n'];
               end
               
               ttnformat = '\n         | ';
               for ii=1:nwd,
                  ttnformat = [ttnformat '%c%c%c%c%c%c%c%c '];
               end
               ttnformat = [ttnformat '|\n'];
            end
            fprintf(ttnformat,cut8(d.variables(nsep(j:end))));
            if isempty(classnum),
               fprintf(tnformat,[d.labels(i:dlim) nd(:,nsep(j:end))]');
            else
               fprintf(tnformat,[d.labels(i:dlim) nd(:,nsep(j:end)) double(cut8(extsymbols{classnum}(nd(:,classnum))'))]');
            end
         end
      end
      
      for j=1:cn:size(ssep,2),
         if j+cn-1 <= size(ssep,2),
            fprintf(tformat,cut8(d.variables(ssep(j:j+cn-1))));
            text ={};
            for k=j:j+cn-1,
               text = [text extsymbols{ssep(k)}(nd(:,ssep(k)))'];
            end
            if isempty(classnum),
               fprintf(sformat,[d.labels(i:dlim) cut8(text)]');
            else
               fprintf(sformat,[d.labels(i:dlim) cut8(text) cut8(extsymbols{classnum}(nd(:,classnum))')]');
            end
         else
            if isempty(tsformat),
               swd = size(ssep,2) - j + 1;
               
               tsformat = '%8.0f | ';
               for ii=1:swd,
                  tsformat = [tsformat '%c%c%c%c%c%c%c%c '];
               end
               if isempty(classnum),
                  tsformat = [tsformat '|\n'];
               else
                  tsformat = [tsformat '| %c%c%c%c%c%c%c%c\n'];
               end
               
               
               ttsformat = '\n         | ';
               for ii=1:swd,
                  ttsformat = [ttsformat '%c%c%c%c%c%c%c%c '];
               end
               ttsformat = [ttsformat '|\n'];
            end
            
            fprintf(ttsformat,cut8(d.variables(ssep(j:end))));
            text ={};
            for k=j:length(ssep),
               curcol = nd(:,ssep(k));
               curcol(find(isnan(curcol)))=length(extsymbols{ssep(k)}); %%% for missing data 
               text = [text extsymbols{ssep(k)}(curcol)'];             
            end
            if isempty(classnum),
               fprintf(tsformat,[d.labels(i:dlim) cut8(text)]');
            else
               fprintf(tsformat,[d.labels(i:dlim) cut8(text) cut8(extsymbols{classnum}(nd(:,classnum))')]');
            end
         end
      end
   end
   
end
%catch
%end


%Now try to save the cached data
try,
	assignin('caller',inputname(1),d);
catch
end

function out = cut8(in)
if ~isempty(in),
   in=in';
   tmp = char(in{:})';
   tmp = [32+zeros(ceil(max(0,8 - size(tmp,1))/2),size(tmp,2)) ; tmp ; 32+zeros(floor(max(0,8 - size(tmp,1))/2),size(tmp,2))];
   out = reshape(tmp(1:8,:),[size(in,1)*8 size(in,2)])';
else
   out =[];
end
